Otherwise, if some of the primitive fluent atoms in ϕ **do not have a successor state** axiom, which means the action may have an indeterminate effect on them, then this action may have an indeterminate effect on F as well. Compute the strongest necessary and weakest sufficient conditions of succ(F) under Init ∪ Succ ∪ Succ**1 as in the**
last step, and output them.

6. This step will try to generate a STRIPS-like description for the action instance A
based on the results of Steps 4 and 5. For each fluent atom F**, do according to one of** the following cases:
(a) if its successor state axiom is succ(F) ≡ true, then put F **into the add list unless**
init(F) is entailed by **Init**;
(b) if its successor state axiom is succ(F) ≡ false, then put F **into the delete list**
unless ¬init(F) is entailed by **Init**;
(c) if its successor state axiom is succ(F) ≡ Φ, and Φ is not the same as true, **false**,
or init(F), then put F **in the conditional effect list and output its successor state**
axiom.

(d) If F **does not have a successor state axiom, then put it in the list of indeterminate**
effects.
Clearly, if F **is not put into any of the lists, then its truth value is not affected by** A.

Steps 4 and 5 of the above procedure are the bottleneck as in the worst case, computing the strongest necessary condition of a proposition is coNP-hard. However, it has been our experience that if action A has a context-free effect on fluent atom F**, then its successor**
state axiom can be computed without going through Step 4.

We have implemented the procedure CCP using the above strategy in SWI-Prolog 3.2.92.

The url for this system is as follows:

## Http://Www.Cs.Ust.Hk/~Flin/Ccp.Html

Using the system, we have encoded in our action description language many of the planning domains that come with the original release of PDDL (McDermott, 1998), and compiled them to STRIPS-like specifications. Our encodings of the domains and the results returned by the system are included in the online appendix. In the following, we illustrate some interesting features of our system using the following two domains: the blocks world and the monkey and bananas domain.

## 5.1 The Blocks World

We have used the blocks world as the running example. Here we shall give an alternative specification of the domain using the following better known set of actions: **stack**,
unstack, pickup, and putdown**. We shall use this domain to show that changing slightly**
the precondition of one of the actions can result in a very different action specification.

2. SWI-Prolog is developed by Jan Wielemaker at University of Amsterdam