
## 5.2 The Monkey And Bananas Domain

This domain is again adapted from McDermott's PDDL library of planning domains, which attributes it to the University of Washington's UCPOP collection of action domains, which in turn attributes it to Prodigy. While some of the action effects generated by our system are context-dependent, they are all context-free in the other systems. We shall elaborate on this difference later.

In this domain, there are two types, loc **for locations (we assume there are three locations**
here), and object **for things like monkey, banana, box, etc.:**
Domain(**loc,** {1, 2, 3}), Domain(object, {**monkey, box,banana, knife, glass, fountain**}).

The following are fluent definitions:

$$t(M)\wedge l o c(X)),$$

Fluent(**onFloor**),

| Fluent(at(M, X), object(M)∧ loc(X)), Fluent(hasknife), Fluent(onbox(X), loc(X)), Fluent(hasbanana), Fluent(haswater), Fluent(hasglass).   |
|-------------------------------------------------------------------------------------------------------------------------------------------|

The following are domain rules about these fluents:

$\left|\right\rangle_{\Phi}$. 

Causes(onbox(X), at(monkey, X)), **(10)**
The following are action definitions along with their respective preconditions and effect axioms:
- goto(x, y) - the monkey goes to x **from** y:
Action(goto(X, Y ), loc(X)∧ loc(Y ) ∧ X 6= Y ), Precond(goto(X, Y ), at(monkey, Y ) ∧ **onFloor**),
Effect(goto(X, Y ), true, at(**monkey, X**)).

| Causes(onbox(X), at(box, X)),                   | (11)   |
|-------------------------------------------------|--------|
| Causes(onbox(X), ¬onFloor),                     | (12)   |
| Causes(onFloor, ¬onbox(X)),                     | (13)   |
| Causes(at(M, X) ∧ X 6= Y, ¬at(M, Y )),          | (14)   |
| Causes(hasglass ∧ at(monkey, X), at(glass, X)), | (15)   |
| Causes(hasknife ∧ at(monkey, X), at(knife, X)), | (16)   |

Causes(hasbanana ∧ at(monkey, X), at(banana, X)). **(17)**
