
## 5.3 Summary

The other domains that we have experimented including a scheduling domain that includes Pednault's dictionary and paycheck domain as a special case, the rocket domain, the SRI robot domain, the machine shop assembling domain, the ferry **domain, the grid domain,** the sokoban domain, and the gear domain. They are all included in the online appendix.

We summarize below some of the common features of these domains:

- In all the domains that we tried, it is quite straightforward **to decide what effects of**
an action should be encoded as direct effects (those given by the predicate Effect**) and**
what effects as indirect effects (those derived from domain rules).

- **The most common domain rules are functional dependency constraints. For instance,**
in the blocks world, the fluent atom on(x, y**) is functional on both arguments; in** the monkey and banana domain, the fluent atom at(object, loc**) is functional on the**
second argument (each object can be at only one location). It **makes sense then that** we would have a special shorthand for these domain rules, and **perhaps a special**
procedure for handling them as well. But more significantly, **given the prevalence**
of these functional dependency constraints in action domains, it is worthwhile to investigate the possibility of a general purpose planner making good use of these constraints.

- **As we mentioned earlier, our system is propositional. The generated successor state**
axioms and STRIPS-like systems are all fully instantiated. **However, it is often easy** for the user to generalize these propositional specifications to first-order ones. We shall investigate the generality of this observation next.

## 6. Generalizing Propositional Strips-Like Systems To Ones **With** Parameters

As we mentioned, for many action domain descriptions, the successor state axioms and STRIPS-like systems generated for a specific domain can be generalized to arbitrary ones.

More precisely, let D **be a domain description, and**
Domain(p1, Dp1

), · · ·, Domain(pk, Dpk
)
its type specification. Suppose in D for action A we have that InitA ∪ SuccA |= ϕ**. Now**
suppose D′is another domain description that is just like D **except that it has a different**
type specification:
Domain(p1, D′p1

), · · ·, Domain(pk, D′pk
).

The question that we are interested in is this: given any one-to-one mapping from the type specification of D to that of D′, will InitA′ ∪ **Succ**A′ |= ϕ
′ be true in D′? Here A′**(resp.** ϕ
′)
is the result of replacing all objects in A (resp. ϕ**) according to the mapping.**
For instance, if the above is true for the blocks world, then we can generalize the results for the domain description in Example 1 as follows. As we have shown, for action stack(1, 2), both succ(on(1, 2)) and ¬succ(on(1, **3)) are true. Now if we change the type specification**
to Domain(block, {a,b,c,d,e}), and if we map 1 to a, 2 to c, and 3 to e**, in the new domain**