where W is a formula and P a literal. Axioms are treated directionally, from W to P**. The** following is the rule and intention for using the axioms according to the manual:
"The rule is that action definitions are not allowed to have effects that mention predicates that occur in the :implies **field of an axiom. The intention is that** action definitions mention 'primitive' predicates like on**, and that all changes in**
truth value of 'derived' predicates like above **occur through axioms. Without**
axioms, the action definitions will have to describe changes **in all predicates that** might be affected by an action, which leads to a complex software engineering (or 'domain engineering') problem."
It is clear from this quotation that axioms in PDDL are intended for defining "derived" predicates. They are similar to our complex fluent definitions. New versions of PDDL have extended the original version by allowing actions with durations and continuous changes. They have not considered using axioms to derive changes to "primitive" predicates like what we have done here with domain rules.

Our action domain description language, while having a very **different syntax that is**
strongly influenced by Prolog syntax, shares much of the same **ideas behind action languages**
(Gelfond & Lifschitz, 1999). However, unlike action languages, ours does not provide facilities for expressing the truth value of a fluent atom in a particular situation like the initial situation. Rather, it is aimed at specifying the generic effects of actions. On the other hand, it has facilities for specifying types and static relations. Most importantly, to date, action languages are either implemented directly or mapped to a nonmonotonic logic programming system rather than by compilation into a monotonic system where action effects are given explicitly, as is done here. For instance, a new SAT-based planning method would have to be implemented (e.g. McCain & Turner, 1998) for action languages. In comparison, once an action domain description is compiled to a STRIPS-like description, existing planning systems such as Blackbox (Selman & Kautz, 1999) or System R (Lin, 2001b) can be directly called.

## 8. Concluding Remarks

We have described a system for generating the effects of actions from direct action effect axioms and domain rules, among other things. We have shown the soundness of the procedure used by the system and tested it successfully in many benchmark action domains used by current AI planners. For future work, we are considering how to generalize the simple action theories in Section 6 to include context-dependent action domain descriptions like the monkey and bananas domain.

## Acknowledgments

An extended abstract of part of this paper appeared in Proceedings of AAAI-2000**. I would** like to thank the anonymous reviewers for both JAIR and AAAI'2000 as well as the associate editor in charge of this paper for JAIR for their insightful comments on earlier versions of this paper. This work was supported in part by the Research Grants Council of Hong Kong under Competitive Earmarked Research Grant HKUST6061/00E.