
## 2.8 Action Effect Specifications

Action effects are specified by expressions of the following form:
Effect(a(x1, ..., xn), ϕ, f(y1**, ..., y**k)),
or of the form:
Effect(a(x1, ..., xn), ϕ, ¬f(y1**, ..., y**k)),
where ϕ is a fluent formula, and f **a primitive fluent. The intuitive meaning of these**
expressions is that if ϕ is true in the initial situation, then action a(x1, ..., xn**) will cause**
f(y1, ..., yk) to be true (false). For instance, in the blocks world, action stack(x, y**) causes**
x **to be on** y:
Effect(stack(x, y), true, on(**x, y**)).

For an example of a context dependent effect, consider action drop(x**) that breaks an object**
only if it is fragile:
Effect(drop(x), fragile(x)**,broken**(x)).

Notice here that the fluent formula ϕ in the action effect specifications can have variables that are not in x1, ..., xn, y1, ..., yk**. Informally, all the variables are supposed to be**
"universally quantified." More precisely, when these expressions are instantiated, one can substitute any objects for these variables, provided the resulting formulas are well-formed.

For instance, given the action effect specification Effect(move(x), g(x1) ∧ q(x1, x2), f(y)),
one can instantiate it to: Effect(move(a), g(b)∧ q(b, c), f(d)), as long as move(a**) is a legal** action (according to the action definition for move) and g(b), q(b, c), and f(d**) are legal**
fluent atoms (according to the fluent definitions for g, q**, and** f).

## 2.9 Domain Rules

Domain rules are specified by expressions of the following form:
Causes(ϕ, f(x1**, ..., x**n)),
or of the following form:
Causes(ϕ, ¬f(x1**, ..., x**n)),
where ϕ is a fluent formula, and f **a primitive fluent. Like action effect specifications,** ϕ here can have variables that are not in x1, ..., xn**. The intuitive meaning of a domain rule**
is that in any situation, if ϕ holds, then the fluent atom f(x1, ..., xn**) will be caused to be**
true. A domain rule is stronger than material implication. Its formal semantics is given by mapping it to a causal rule of Lin (1995) (see Section 4), thus the name "causes". For instance, in the blocks world, a block can be on only one other **block:**
Causes(on(x, y) ∧ y 6= z, ¬on(**x, z**)).

In a logistics domain, one may want to say that if a package is inside a truck which is at location l, then the package is at location l **as well:**
Causes(in(x, y) ∧ at(y, l), at(**x, l**)).