links. The linking of an open condition q@τ
−→ai **to an effect associated with a time point** tj gives rise to the temporal constraint dkj ≤ −ǫ (k = 2i if τ = e, else k = 2i − **1). Figure 2(c)**
shows the representation of the STN for a plan with actions a1 and a2**, as before, and with**
an effect associated with the end of a2 **linked to a condition associated with the end of** a1.

Unsafe causal links are resolved in basically the same way as **before, but instead of**
adding ordering constraints between actions we add temporal constraints between time points ensuring that one time point precedes another time point. We can ensure that time point ti precedes time point tj by adding the temporal constraint dji ≤ −ǫ.

Every time we add a temporal constraint to a plan, we update all shortest paths dij that could have been affected by the added constraint. This propagation of constraints can be carried out in O(|A|2**) time.**
Once a plan without flaws is found, we need to schedule the actions in the plan, i.e. assign a start time and duration for each action. A schedule of the actions is a solution to the STN
T **, and a solution assigning the earliest possible start time to each action is readily available**
in the d-graph representation. The start time of action aiis set to −d2i−1,0 **(Corollary 3.2,**
Dechter et al., 1991) and the duration to d2i−1,0 − d2i,0**. Assuming Figure 2(c) represents**
the STN for a complete plan, then we would schedule a1 **at time 1 with duration 5 and** a2 at time 1 with duration 4. We can easily verify that this schedule is indeed consistent with the duration constraints given for the actions, and that a2 ends before a1 **as required.**
Each non-durative action can be treated as a durative action **of fixed duration 0, with**
preconditions associated with the start time, effects associated with the end time, and without any invariant conditions. This allows for a frictionless treatment of domains with both durative and non-durative actions.

Let us for a moment consider the memory requirements for temporal POCL planning compared to classical POCL planning. When planning with non-durative actions, we store O as a bit-matrix representing the transitive closure of the ordering constraints in O**. For a**
partial plan with n **actions, this requires** n 2 bits. With n **durative actions, on the other hand,**
we need roughly 4n 2 floating-point numbers to represent the d-graph of T . Each floatingpoint number requires at least 32 bits on a modern machine, so **in total we need more than**
100 times as many bits to represent temporal constraints as regular ordering constraints for each plan. We note, however, that each refinement changes **only a few entries in the** d-graph, and by choosing a clever representation of matrices we can share storage between plans. The upper left 3 × **3 sub-matrix in Figure 2(b) is for example identical to the matrix**
in Figure 2(a). The way we store matrices in VHPOP **allows us to exploit this commonality**
and thereby reduce the total memory requirements.

The addition of durative actions does not change the basic POCL algorithm. The recording of temporal constraints and temporal annotations can be handled in a manner transparent to the rest of the planner. The search heuristics described in Section 3, although not tuned specifically for temporal planning, can be used with durative actions. We only need to slightly modify the definition of literal and action cost in the additive heuristic because of the temporal annotations associated with preconditions and effects of durative actions. Let GAs(q) denote the set of ground actions achieving q **at the start, and** GAe(q)