
| Domain     | # Solved   | # Steps   | # Best   | Execution Time   | # Best   |
|------------|------------|-----------|----------|------------------|----------|
| DriverLog  | 14         | 1.09      | 5        | 1.15             | 4        |
| ZenoTravel | 13         | 1.04      | 7        | 1.20             | 5        |
| Satellite  | 17         | 1.07      | 7        | 1.25             | 5        |
| Rovers     | 20         | 1.08      | 7        | 1.08             | 13       |

Table 10: Relative plan quality for the STRIPS domains where VHPOP **solved more than**
half of the problems. There are two plan quality metrics. Number of steps is simply the total number of steps in a plan, while execution time is the total time required to execute a plan (counting parallel actions as one time step). The table shows the average ratio of VHPOP**'s plan quality and the quality of the**
best plan generated by any planner, and the number of problems in each domain where VHPOP **found the best plan is also shown.**

| Planner    | Depots   | DriverLog   | ZenoTravel   | Satellite   | Rovers   | FreeCell   | Total   |
|------------|----------|-------------|--------------|-------------|----------|------------|---------|
| FF         | 22       | 15          | 20           | 20          | 20       | 20         | 117     |
| LPG        | 21       | 18          | 20           | 20          | 12       | 18         | 109     |
| MIPS       | 10       | 15          | 16           | 14          | 12       | 19         | 86      |
| Simplanner | 22       | 11          | 20           | 17          | 9        | 12         | 91      |
| Stella     | 4        | 10          | 18           | 14          | 4        | 0          | 50      |
| VHPOP      | 3        | 14          | 13           | 17          | 20       | 1          | 68      |

In domains with durative actions5**, total execution time was given as an explicit plan**
metric, and the objective was to minimize this metric. The specification of an explicit plan metric is a feature of PDDL2.1 not present in earlier versions of PDDL. As VHPOP **currently ignores this objective function and always tries to find plans with few steps, it should**
come as no surprise that the quality of VHPOP**'s plans for domains with durative actions**
was significantly worse than the quality of the best plans found (Table 12).6 VHPOP
still produced plans with few steps, however, with over 60 percent of VHPOP**'s plans for**
domains with durative actions having the fewest steps. The plan selection heuristic that VHPOP **uses is tuned for finding plans with few steps, and it would need to be modified in**
order to find plans with shorter total execution time. Table 13 shows that LPG **solved by** far the most problems in domains with durative actions, but that VHPOP **was competitive** with MIPS **and clearly outperformed** TP4 and TPSYS.