
| Domain     | STRIPS   | Durative   |
|------------|----------|------------|
| DriverLog  | 2.52     | 2.66       |
| ZenoTravel | 2.76     | 2.86       |
| Satellite  | 1.78     | 2.01       |
| Rovers     | 2.32     | 3.37       |

that temporal POCL planning can be made practical by using the same heuristic techniques that have been developed for classical planning. The idea of **using the POCL paradigm for**
temporal planning is not new and goes back at least to Vere's DEVISER **(Vere, 1983), but**
we are the first to demonstrate the effectiveness of temporal POCL planning on a larger set of benchmark problems.

We hope that the success of VHPOP **at IPC3 will inspire a renewed interest in plan**
space planning, and we have made the source code for VHPOP**, written in C++, available**
to the research community in an online appendix so that others can build on our effort.7 While VHPOP **performed well above our expectations at IPC3, we see several ways in**
which we can further improve the planner. Speed, as mentioned in Section 5, is the principal weakness of VHPOP**. The code for the reachability analysis is not satisfactory, as it currently generates ground action instances before performing any reachability analysis. This**
often leads to many ground action instances being generated **that do not have preconditions**
with finite heuristic cost (according to the additive heuristic). We believe that VHPOP
could profit from code for reachability analysis in well-established planning systems such as FF**. We could also improve speed by better scheduling different flaw selection strategies.**
We would like to see statistical studies, similar to that of Howe et al. (1999), linking domain and problem features to the performance of various flaw selection strategies.

We have so far only considered using different flaw selection strategies. However, running multiple instances of VHPOP **using different plan selection heuristics could be equally**
interesting. We have, for example, noticed that using the additive heuristic without **accounting for reuse helps us solve two more problems in the Satellite domain. It would also be**
interesting to have the FF **heuristic implemented in** VHPOP **and see how well it performs**
in a plan space planner, possibly using local search techniques instead of A∗**. It is not likely,**
however, that the results on local search topology for the FF **heuristic in state space (Hoffmann, 2001) carry over to plan space. While many of the benchmark planning domains**
contain actions whose effects can be undone by other actions, **the plan operators causing** transitions in the search space of a plan space planner are different from the actions defined for a planning domain, and the effects of a plan space operator **are generally irreversible.**
We would likely need to add transformational **plan operators that can undo linking and**
ordering decisions. Incidentally, VHPOP **started out as a project for adding transformational plan operators to** UCPOP**, but we got side-tracked by the need for better search**