
## 3.3.3 Pddl Operator Translation

SHOP2's planning procedure can be proved to be sound and complete across a large set of planning problems, in the sense that if a set of methods and operators is capable of generating a solution for some problem, then the planning procedure is guaranteed to generate a correct plan (Nau et al., 2001). However, while such a proof **tells us that the planning**
algorithm should work correctly if the domain description is correct, it does not tell us whether our domain description represents the same planning domain as a given set of PDDL planning operators.

In the AIPS-2000 planning competition, that problem caused **difficulty for SHOP2's**
predecessor SHOP. The SHOP team was developing domain descriptions for SHOP purely by hand, and made some mistakes in writing two of the domains. **Thus SHOP found**
incorrect solutions for some of the problems in those domains, so the judges disqualified SHOP from those domains.

While developing SHOP2, we wrote a translator program to translate PDDL operators into SHOP2 domain descriptions. The domain descriptions produced by the translator program are not sufficient for efficient planning with SHOP2: they need to be modified by hand in order to put in the domain knowledge, as described in Section 4. However, the translator program can at least provide a correct starting point.

## 3.3.4 Debugging Facilities

SHOP2 also includes several debugging facilities. The most **important of these is a tracing** mechanism: one can tell SHOP2 to trace any set of operators, methods, and axioms. For example, in Figure 8, we have given names (namely Case1 and Case2**) to the two different**
clauses of a method. We can tell SHOP2 to trace either of these **clauses or both of them;**
SHOP2 will print messages each time it enters and exits a clause that is being traced. Depending on the particular tracing options that one selects, the messages may include things such as the argument list, the current state of the world, and information about whether the operator, method or axiom succeeds or fails.

## 3.3.5 Protected Conditions And Anti-Interleaving

SHOP2's planning operators include a way to specify protected conditions. This feature is described briefly in Nau et al. (2001), but we will not bother to describe it here because we did not use it during the planning competition. In cases where we wanted to protect conditions from possible threats, we found it more convenient either to make use of flags similar to the available-truck **flag in Figure 1, or to use the following "anti-interleaving"**
feature of SHOP2.

If a method m has subtasks t1, . . . , tk, and if any ti **begins with the keyword** :immediate, this tells SHOP2 that it should plan to do tiimmediately after ti−1 **finishes, without trying to**
interleave other tasks between ti−1 and ti**. Several examples of this appear in the appendix.**