

![0_image_0.png](0_image_0.png)

To keep the description of MTP simple, let us suppose that in each state s**, every atom**
(p c1 . . . cn) represents a single-valued property, i.e., there is at most one cn **such that** (p c1
. . . cn−1 cn) is true in s**. A property is** *dynamic* **if an operator may change the value of** cn.

For example, if the initial state contains (at plane1 city1) **but if there is an operator that**
moves plane1 **to a different location, then the location of** plane1 **is dynamic.**
For each property p **that changes over time, MTP modifies the operators to keep track,**
within the current state, of the times at which the property changes and the times at which various preconditions depend on the property. The idea is that for each dynamic property p**, the current state will contain two time-stamps:** *read-time*(p**), which is the last time that** any action read the value of p**, and** *write-time*(p**), which is the last time that any action** modified the value of p**. MTP modifies the operators in such a way that whenever an**
operator reads (i.e., accesses) a dynamic property, the operator will update the property's read-time, and if an operator writes (i.e., modifies) a dynamic property, it will update the property's write-time. Thus, instead of a single "global time," the current state will contain many "local times," namely a read-time and a write-time for each dynamic property.

MTP also inserts preconditions into each action to ensure that the action begins on or after the *read-time* **of each property that it writes and the** *write-time* **of each property that** it reads. This prevents two actions from overlapping in time **if one of them writes to a** property and the other reads from it. For example, a boarding **operator and a fly operator**
on the same plane may not overlap, because the boarding operator requires that the plane be located in a particular city and the fly operator changes the location of the plane.

Figure 11 shows one of the SHOP2 operators produced by MTP for **the ZenoTravel**
domain. The operator involves two dynamic properties: a vehicle's fuel level and its location. The operator reads both of these properties, so it may not start before their write times. However, it only writes one of them (the fuel level), so it may **start before the read time** of the vehicle's location. Thus refueling may be performed concurrently with any other actions that depend on the vehicle's location, but cannot be **performed concurrently with** any actions that modify the fuel level or that modify the vehicle's location.