The first approach works well if it is easy to tell which alternative will be best at each node of the search space. For example, if you know that in all problem instances the objective will be to minimize the total fuel used, then a perfect heuristic for the ZenoTravel domain is to always use the fly **action instead of the** zoom **action. However, this approach** doesn't work so well if it isn't immediately obvious which alternative is best. For example, if the objective is to minimize the total time, then a naive approach would be always to use the zoom **action rather than the** fly **action, since the** zoom **action is faster. However, the** zoom **action is not always the best choice, because it requires more fuel and thus can cause** delays for refueling.

The second approach is an extension of the first approach. Consider again the example in ZenoTravel domain where the objective is to minimize the total fuel used. In addition to making the planes fly **instead of** zoom**; using a closer plane to transport a person also**
reduces the total fuel used. We can set this preference using **the sort-by feature of SHOP2.** In the precondition of the method for transporting a person we can sort the available planes according to the fuel they will use in order to pick up this person. This is a greedy approach. At each decision point we can sort the alternatives by cost, and go with the alternative that has the lowest objective-function value. Thus, this approach is not guaranteed to find the optimal solution. However, if combined with suitable heuristics, this approach results in near-optimal plans. In the competition we used this technique extensively, and it produced satisfactory plans even for the largest problems.

The third approach makes use of branch-and-bound optimization, as explained in Section 3.3.2. The main idea is to quickly define methods that will let **you find a plan which may**
be poor in quality and then let SHOP2 perform branch-and-bound search in the plan space to find the least cost plan or the best plan it can find within the **execution time limit.**
For the third approach, there is a challenge in setting up the **cost of each operator. For**
example, if the objective function requires minimizing the **total time, then in order to take**
concurrency into account, the cost of an action a **should not always be equal to its duration.**
For example, suppose the latest event in the current partial **plan is for a plane to arrive**
at an airport at time t**, and two passengers need to board the plane. Then we need to**
add two boarding actions to the plan. Recall that in the ZenoTravel domain, all boarding actions take the same amount of time, tb**, and can be performed concurrently. However,**
SHOP2 needs to add the actions to the plan one at a time. The first boarding action will increase the total time by tb, so its cost is tb**. However, the second boarding action will not**
increase the total time of the plan, so its cost is 0. Now, suppose we add a "refuel" action to the plan. This action can be done concurrently with the boarding actions, so its cost is max(0, tr − tb), where tr **is the time needed to refuel.**
It is possible to combine two or more of the above approaches. **However, in our experience, using optimization (the third approach) did not provide much benefit for domain**
descriptions that already included the other two approaches. In these situations, SHOP2 would frequently find an optimal or nearly optimal plan even without optimization, which meant that the additional amount of time needed by branch-and-bound optimization would produce little or no benefit. Branch-and-bound optimization would perhaps be more useful in planning domains where the cost of a plan is something other than the sum of the costs of the operators; however, such domains did not occur in the planning competition.