In the International Planning Competition, we did not use the optimization approach in any official competition trial. For all of the competition domains, in our preliminary testing of SHOP2 with optimization and no time limits, SHOP2 **was unable to find solutions**
within the amount of time that we were willing to let it run, except on the very smallest problems. One way to overcome this difficulty would have been to use time limits, but in our preliminary tests, this never provided significant improvements in cost across an entire problem set. One reason for this lack of improvement was that **we spent a great deal of** effort crafting the methods used in the competition. We think **the third approach would** be more useful in cases where it is not immediately clear how to implement the first two approaches, and one does not want to spend too much time devising a sophisticated domain description.

## 5. Competition Results

Fourteen planning systems competed in the 2002 International Planning Competition.

SHOP2 received a "distinguished performance" award, one of **the top four awards.**
SHOP2 (along with TLPlan and TALPlanner) was one of three planners that solved problems in both the "hand-tailored" and "fully automated" **tracks. SHOP2 was able to** solve problems in the Strips, Numeric, HardNumeric, SimpleTime, Time, and Complex domains. SHOP2 solved more problems than any other planner in the competition: it solved 899 out of 904 problems, for a 99% success ratio.

Of the other two hand-tailorable planners, TLPlan solved 894 problems, nearly as many as SHOP2. Since TALPlanner didn't do numeric domains, it solved only 610 problems, but that still was several hundred more problems than the fully-automated planners solved.

In general, SHOP2 tended to be slower than TALPlanner and TLPlanner, although there was one domain (Satellite-HardNumeric) where SHOP2 was consistently the fastest. The speeds of the three hand-tailorable planners generally **appeared to be polynomially** related to each other, probably because these planners' domain knowledge enabled them to find solutions without doing very much backtracking. All three hand-tailorable planners were generally much faster than most of the fully-automated **planners.**
None of the three hand-tailorable planners dominated the other two in terms of plan quality. For each of them, there were situations where its solutions were significantly better or significantly worse than the other two.

## 6. Related Work

The following subsections discuss HTN planning, ordered task decomposition, and the other hand-tailorable planners that participated in the competition.

## 6.1 Htn Planning

HTN planning was first developed more than 25 years ago (Sacerdoti, 1990; Tate, 1977). Historically, most of the HTN-planning researchers have focused on practical applications.

Examples include production-line scheduling (Wilkins, 1988), crisis management and logistics (Currie & Tate, 1991; Tate, Drabble, & Kirby, 1994; Biundo & Schattenberg, 2001),
planning and scheduling for spacecraft (Aarup, Arentoft, Parrod, Stader, & Stokes, 1994;