paths in the search space. One difference between TLPlan and TALPlanner is that TLPlan uses a linear modal tense logic, while TALPlanner use TAL, a narrative-based linear temporal logic used for reasoning about action and change in incompletely specified dynamic environments.

The main difference between both of these planners and SHOP2 is the kind of control knowledge they use: TLPlan and TALPlanner use their temporal formulas to tell which part of the search space should be avoided, whereas SHOP2 uses its HTN methods to tell which parts of the search space should be explored. SHOP2's search space consists only of those nodes that are reachable using its HTN methods, whereas TLPlan and TALPlanner can explore any part of the search space that avoids the "bad" **states and their successors.** It is hard to say which type of control knowledge is more effective. Bacchus and Kabanza (2000) argue that the two types are useful in different situations and that combining them is a useful topic for future research.

## 7. Summary And Conclusions

The primary difference between SHOP2 and most other HTN planners is that SHOP2 plans for tasks in the same order that they will be executed, and thus it knows the current state at each step of the planning process. This reduces the complexity of reasoning by removing a great deal of uncertainty about the world, which has made it **easy for us to incorporate substantial expressive power into SHOP2. In addition to the usual HTN methods**
and operators, SHOP2's domain descriptions may include axioms, mixed symbolic/numeric conditions, and external function calls. The planning procedure is Turing-complete, and is sound and complete over a large class of planning problems (Nau et al., 2001).

Like other HTN planning systems, SHOP2 plans by decomposing **tasks into subtasks.**
A key idea in using any HTN planner is to design a set of methods **that encode something** akin to "standard operating procedures" that capture multi-step techniques for refining a task. Some kinds of domain characteristics are much more natural to express in an HTN formalism than in action-based formalism; see Lotem et al. (1999) for a description of some of the issued involved.

As an example, consider the UM-Translog-2 domain, which we wrote for use as a problem domain in the AIPS-2002 planning competition (Wu & Nau, 2002). UM-Translog-2 is a straightforward generalization of the UM Translog domain **(Andrews, Kettler, Erol, &** Hendler, 1995); the generalizations include numeric information such as distances, fuel usage, and so forth. It was relatively straightforward to formulate UM-Translog-2 as an HTN planning domain. However, it was much more difficult to figure out how to formulate UM-Translog-2 as a PDDL domain for use by other competitors in the planning competition; that task took several months to accomplish.

As with most other HTN planning systems, SHOP2's development was originally motivated not by the planning competition but instead to try to **solve practical planning**
problems. For example, JSHOP (a Java implementation of SHOP2's predecessor SHOP)
is the generative-planning component of the HICAP system for planning evacuation operations (Mu˜noz-Avila et al., 2001), and we are currently incorporating SHOP2 into HICAP
as a replacement for JSHOP. We are very pleased that SHOP2's capabilities also gave it the ability to excel in the International Planning Competition!