
## Acknowledgments

This work was supported in part by the following grants, contracts, and awards: Air Force Research Laboratory F30602-00-2-0505, Army Research Laboratory DAAL0197K0135, Naval Research Laboratory N00173021G005, and the University of Maryland General Research Board. The opinions expressed in this paper are those of authors and do not necessarily reflect the opinions of the funders.

We also wish to thank the anonymous reviewers, whose comments helped us to make significant improvements to this paper.

## Appendix A. Shop2 Domain Description For The Zenotravel Domain (Numeric Version)

In the AIPS-2002 Planning Competition, there were four different versions of the ZenoTravel domain: the Strips version, the Numeric version, the Simple **Time version, and the Time** version. We developed SHOP2 domain descriptions for all four versions.

What follows is our domain description for the Numeric version of the ZenoTravel domain. The operators in our domain description are translated from the original PDDL
coding using a rough approximation of the MTP process in Figure 10.

(defdomain ZENOTRAVEL
(
(:- (same ?x ?x) ()) (:- (different ?x ?y) ((not (same ?x ?y)))) (:-(possible-person-in ?city)
((person ?p) (at ?p ?city) (goal ?p ?city2)
(different ?city2 ?city)))
(:operator (!!cost ?end)
((maxtime ?max)
(assign ?newmax (eval (if (< ?max ?end) ?end ?max))))
((maxtime ?max))
((maxtime ?newmax)) (- ?newmax ?max))
(:method (board ?p ?a ?c) ((write-time ?a ?start))
((!board ?p ?a ?c ?start 1)
(:immediate !!cost (call + ?start 1))))
(:operator (!board ?p ?a ?c ?start ?duration)
((person ?p) (aircraft ?a) (city ?c)
(at ?a ?c) (at ?p ?c) (onboard ?a ?num)
(read-time ?a ?pmax) (assign ?new-num (+ ?num 1))
(assign ?newpmax (max ?pmax (+ ?start ?duration 0.01L0)))) ((onboard ?a ?num) (read-time ?a ?pmax) (at ?p ?c) (dest ?a ?c))
((onboard ?a ?new-num) (read-time ?a ?newpmax) (in ?p ?a))