
## 3.2 The Shop2 Algorithm

Figure 5 shows a simplified version of the SHOP2 planning procedure. The arguments include the initial state s, a partially ordered set of tasks T**, and a domain description** D.

As we mentioned earlier, SHOP2 plans for tasks in the same order that they will be executed. In order to do this, it nondeterministically chooses a task t ∈ T **that has no** predecessors; t **is the first task that SHOP2 will start working on. At this point, there are**
two cases.

The first case is if t is *primitive*, i.e., if t **can be accomplished directly using an action**
(i.e., an instance of a planning operator). In this case, SHOP2 finds an action a **that** matches t and whose preconditions are satisfied in s, and applies a to s **(if no such action**
exists, then this branch of the search space fails).

The second case is where t is *compound***, i.e., a method needs to be applied to** t to decompose it into subtasks. In this case, SHOP2 nondeterministically chooses a method instance m that will decompose t **into subtasks (if no such method instance exists, then this**
branch of the search space fails).

If there is a solution plan that involves m, then the actions in P **will be the leaf nodes**
of a decomposition tree DP **such as the tree shown in Figure 2. The precondition formula**
pre(m) must be true in the state that immediately precedes the first action a in DP **that is** a descendant of m. In order to ensure that pre(m**) is true in the correct state, SHOP2 needs** to generate the leftmost branch of D **all the way down to the bottom, and evaluate pre(**m) in the state just before a**. The last three lines of the loop ensure that this will happen, by** telling SHOP2 that if the current method m **has any subtasks, SHOP2 should generate one**
of those subtasks before generating any other subtasks in the task network.

For example, SHOP2 could begin generating the plan in Figure **2 by first decomposing**
(transport-two p1 p2) **into** (transport p1) and (transport p2)**, and then nondeterministically**
choosing to decompose (transport p1) **into** {(dispatch t1 l1), (pickup t1 p1), (move t1 l1 l3)}**. Having done that, SHOP2 would be required to decompose** (dispatch t1 l11) **before**
decomposing (transport p2)**, in order to guarantee that** (dispatch t1 l1) and (reserve t1)
occur in the same state of the world in which (available t1) **was evaluated. The operator** for (reserve t1) **makes t1 unavailable, thus ensuring that when** (transport p2) **is decomposed** later, the decomposition will use truck t2 **rather than** t1.

## 3.3 Additional Features

SHOP2 has several additional features in addition to the basic ones described earlier. This section describes the most significant ones.

## 3.3.1 Sorting The Variable Bindings

When SHOP2 evaluates a method's precondition, it gets a list **of all of the possible sets**
of variable bindings that satisfy the expression in the current state. Each set of variable bindings can lead to a different branch in SHOP2's search tree. This nondeterministic choice is implemented in SHOP2 via depth-first backtracking. For SHOP2 to find a good solution and to find it quickly, it is important to decide which set of variable bindings to try first.

For this purpose, SHOP2 has a "sort-by" construct that sorts the list of variable bindings by a specified criterion. This is especially useful when **the planning problem is an**