# An Architectural Approach To Ensuring Consistency In Hierarchical Execution

Robert E. Wray wrayre@acm.org Soar Technology, Inc., 3600 Green Court, Suite 600 Ann Arbor, MI 48105 USA
John E. Laird laird@umich.edu The University of Michigan, 1101 Beal Avenue Ann Arbor, MI 48109 USA

## Abstract

Hierarchical task decomposition is a method used in many agent systems to organize agent knowledge. This work shows how the combination of a hierarchy and persistent assertions of knowledge can lead to difficulty in maintaining **logical consistency in asserted** knowledge. We explore the problematic consequences of persistent assumptions in the reasoning process and introduce novel potential solutions. Having implemented one of the possible solutions, Dynamic Hierarchical Justification**, its effectiveness is demonstrated** with an empirical analysis.

## 1. Introduction

The process of executing a task by dividing it into a series of hierarchically organized subtasks is called hierarchical task decomposition**. Hierarchical task decomposition has been** used in a large number of agent systems, including the Adaptive Intelligent Systems architecture (Hayes-Roth, 1990), ATLANTIS (Gat, 1991a), Cypress (Wilkins et al., 1995),
the Entropy Reduction Engine (Bresina, Drummond, & Kedar, 1993), the Procedural Reasoning System (Georgeff & Lansky, 1987), RAPS (Firby, 1987), **Soar (Laird, Newell, &**
Rosenbloom, 1987; Laird & Rosenbloom, 1990), and Theo (Mitchell, 1990; Mitchell et al., 1991), and is a cornerstone in belief-desire-intention-based agent implementations (Rao & Georgeff, 1991; Wooldridge, 2000). Hierarchical task decomposition helps both an agent's knowledge developer and the agent itself manage environmental complexity. For example, an agent may consider high-level tasks such as "find a power source" or "fly to Miami" independent of low-level subtasks such as "go east 10 meters" or "turn to heading 135." The low-level tasks can be chosen dynamically based on the currently active high level tasks and the current situation; thus the high-level task is **progressively decomposed into** smaller subtasks. This division of labor simplifies the design of agents, thus reducing their cost. Additional advantages of hierarchical task decomposition include knowledge sharing (a low-level subtask can be invoked for many different high-level procedures), modularity (the decomposition helps insulate subtasks from interaction with other knowledge) and the naturalness of this representation (Simon, 1969).

Without careful design, it can be difficult to ensure consistent reasoning in agents employing hierarchical task decompositions. By "consistency," we mean that reasoning does not lead to a set of assertions that contains a contradiction. Ensuring consistency becomes