their generality, by definition, architectural solutions are also complete, and thus able to guarantee consistency between the hierarchical context and assumptions within a subtask, at all times, for any agent task. Such completeness should improve the robustness of agent systems, especially in situations not explicitly anticipated by their designers.

## 3.2 Assumption Justification

One potential architectural solution to the inconsistency problem is to justify each assumption in the hierarchy with respect to assertions in higher levels of the hierarchy. **Assumption**
Justification **is an extension of the truth maintenance approaches to consistency outlined**
previously. Each assumption in the hierarchy is treated as if it were an entailment with respect to dependent assertions higher in the hierarchy. A new data structure, the assumption justification, is created that captures the reasons in the hierarchical context for a particular assumption. Locally, an assumption is treated **exactly like an assumption in a**
non-hierarchical system. However, when the assumption justification is no longer supported
(indicating a change in the dependent hierarchical context), the architecture retracts the assumption.

Refer again to Figure 2. When the agent asserts a34, the architecture builds an assumption justification for the assumption that includes a22 and a21**. If the agent retracts**
a21, the assumption justification for a34 **is no longer supported and the architecture also**
retracts a34**. The architecture ensures reasoning consistency across hierarchy levels because**
an assumption persists no longer than the context assertions that led to its creation.

Assumption Justification solves the inconsistency problem **because all dependencies in**
the hierarchical context are captured in the justification. **Within the subtask, domain knowledge is still required to ensure consistency among the enabled assumptions in the subtask.**
However, no across-level consistency knowledge is needed. **Assumption Justification still** supports local nonmonotonic and hypothetical reasoning. Thus, Assumption Justification appears to meet functional evaluation criteria. However, in order to assess its impact on performance, some implementation details must be considered.

## 3.2.1 Implementing Assumption Justification

Creating assumption justifications requires computing context dependencies for each assumption, similar to the computation of justifications for entailments.2 **Figure 7 outlines**
a procedure for computing the assumption justification data **structure. This procedure is** invoked when any assertion is created. This procedure creates assumption justifications for every assertion in a local subtask; that is, for entailments **as well as assumptions. This approach allows the architecture to cache context dependencies for each local assertion. The**
advantage of this caching is that the architecture can simply concatenate the assumption justifications of the local assertions contributing directly to the creation of the assumption