PROC create new assertion(**. . .**)
An assumption justification is computed when each new assertion A is created. Thus, assumption justifications are computed for both assumptions and entailments.

. . .

Ajust ← create justif ication(**. . .**)
Justifications can be created via well-known, textbook algorithms (e.g., Forbus & deKleer, 1993; Russell & Norvig, 1995)
Aaj ← make assumption justif ication for **assertion**(A)
. . .

END
PROC make assumption justif ication for assertion(**assertion A**)
AJ ← NIL
FOR **Each assertion** j in Ajust**, the justification of A**
1 IF (Level(j) closer to the root than **Level**(A))
AJ ← append(j, AJ) (add j **to the assumption justification)**
2 ELSE (j and A **at the same level)**
AJ ← concatenate(jaj , AJ**) (add assumption justification of** j to assumption justification of A)
return AJ, a list of assertions comprising the assumption justification of A
END
PROC Level(**assertion A**)
Return the subtask level associated with assertion A
Figure 7: A procedure for building assumption justifications.

![0_image_0.png](0_image_0.png)

(in **2). We chose this caching option for computing assumption justifications over an "ondemand" implementation that would, when an assumption was created, recursively follow**
local dependencies until all context dependencies were determined. The advantage of the caching implementation is that the context dependencies for any assertion must be computed only once, even when a local assertion contributes to the creation of multiple local assumptions.

The procedure that creates an assumption justification loops over the assertions in the justification of a new assertion A**. The assertions in the justification can be either context or**
local assertions. Context assertions, in **1, are added to the assumption justification directly.** However, local assertions should not be added to the assumption justification because the assumption justification should include only context dependencies. For example, the architecture can retract a local assertion for reasons other than a change in the hierarchical context (e.g., a non-monotonic reasoning step or a change in **enabled assumptions in the** subtask) and in these cases, the agent should not necessarily retract dependent assumptions. Because assumption justifications for all local assertions **in the justification have already**
been computed (i.e., they are cached, as described above), the assumption justification of a