least 100% more time than the original Air-Soar agent. Further, the number of assumption justifications maintained within a level continued to grow during execution, for the reasons explained above. Some subtasks required minutes to execute **as the aircraft performed a** maneuver, leading to large (and problematic) increases in the amount of memory required. Thus, Assumption Justification failed to meet efficiency requirements on both theoretical and empirical grounds. Although the limitations of Assumption Justification might be improved by developing solutions to its technical problems, we abandoned further exploration of this approach after such strongly discouraging results.

## 3.3 Dynamic Hierarchical Justification

Figure 2 introduced the notion of a support set for subtasks. **Both the Procedural Reasoning** System (PRS) (Georgeff & Lansky, 1987) and Soar (Laird et al., **1987) use architectural**
mechanisms to retract complete levels of a subtask hierarchy when the support set no longer holds. In this section, we consider a solution that leverages the hierarchy maintenance function to ensure consistency between assumptions and the **higher level context.**
A significant disadvantage of the support set in existing systems is that it is fixed**. In**
Soar, the support set is computed for the initiation of the subtask but is not updated to reflect reasoning that occurs within the subtask. For example, in Figure 2, suppose that assumption a34 depends on assumptions a22 and a21 **(represented by the dashed, arrowed**
lines). The support set does not include a21**; this assertion may not have even been present**
when Subtask3 was created. When a local assumption depends on an assertion **not in the**
support set, then a change in that assertion will not directly lead to the retraction of the assumption (or the subtask). Thus, approaches using such **Fixed Hierarchical Justification**
(FHJ) still require knowledge-based solutions for consistency. FHJ is discussed further in Section 5.1.2.

We propose a novel solution, Dynamic Hierarchical Justification **(DHJ), that is similar**
to Fixed Hierarchical Justification, but dynamically updates the support set as reasoning progresses. Assumption justifications for individual assumptions are unnecessary. However, one consequence of this simplification is that a subtask (and **all assertions within it) will** be retracted when the dependent context changes. Refer to Figure 2. When a DHJ agent asserts a34 in Figure 2, the architecture updates the support set for Subtask3 **to include** a21.

Assumption a22 **is already a member of the support set and need not be added again. When**
any member of the support set for Subtask3 **changes, the architecture retracts the entire**
subtask. Thus Dynamic Hierarchical Justification enforces **reasoning consistency across the** hierarchy because a subtask **persists only as long as all dependent context assertions.**

## 3.3.1 Implementing Dynamic Hierarchical Justification

Figure 9 outlines the procedure for computing the support set in DHJ. As in Assumption Justification, the architecture can directly add context assertions to the support set 1. When the architecture computes the dependencies for a local assertion **3, the assertion** is marked as having been inspected **4. Inspected assertions can simply be ignored in the** future **2, because the architecture has already added the assertion's dependencies to the** support set. The architecture will also ignore dependent, local assumptions **2 because**
the dependencies of those assumptions will have already been added to the support set.