PROC create new assertion(**. . .**)
Whenever a new assumption is asserted, the support set is updated to include any additional context dependencies.

. . .

Ajust ← create justif ication(**. . .**)
IF **A is an assumption**
S is the subtask in which A is asserted Ssupport set ← **append**(Ssupport set, add dependencies to support set(A))
. . .

END
PROC add dependencies to support set(**assertion A**)
FOR **Each assertion** j in Ajust**, the justification of A**
1 IF {Level(j) closer to the root than **Level**(A)}
append(j, S**) (append context dependency to support set)**
2 ELSEIF {Level(j) same as Level(A**) AND**
j **is NOT an assumption AND**
j **has not previously been inspected** }
3 S ← append(S, add dependencies to support set(j))
(compute support set dependencies for j **and add to S)**
4 jinspected ← **true**
(j**'s context dependencies have now been added to the support set)**
return S, the list of new dependencies in the support set END
PROC Level(**assertion A**)
Return the subtask level associated with assertion A
Figure 9: A procedure for Dynamic Hierarchical Justification.

Because DHJ needs to inspect any local assertion only once, context dependencies are computed on-demand, rather than cached as in Assumption Justification. Condition **2 will** be true whenever there is a local entailment whose context dependencies have not yet been computed. These dependencies are determined by calling add dependencies to support set recursively. Recursive instantiations of add dependencies to support set **each receive a local** assertion in the justification of an uninspected entailment, j**, and return a list comprising**
the context dependencies of j**. The return value is then appended to the support set** S in the prior instantiation of add dependencies to support set.

The recursive call to add dependencies to support set at **3 is the only non-constant time**
operation in the procedure. It must be made only once for any assertion ji **and thus the**
worst case complexity to compute the dependencies is linear **in the number of assertions in** the level, as in Assumption Justification. However, DHJ requires only a single inspection of any individual assertion, rather than repeated inspections for each new assumption as in As-