posable **(Simon, 1969). Thus, the goal of a hierarchical decomposition is to separate mostly**
independent subtasks from one another. A consequence of this separation is that dependencies in higher levels will be limited as much as possible (interaction between subtasks should be minimized) and the dependencies among the assertions in any particular subtask will be shared (otherwise, the subtask could be subdivided into two **or more independent subtasks).** Of course, it is often possible to decompose a given task in many different ways. In most cases the domain imposes minimal constraint and the knowledge engineer has significant latitude in crafting the task decomposition.

In the situation illustrated in Figure 10, (b) would be a more **complete decomposition**
of a task by the knowledge engineer than (a), assuming the two **alternatives represent a**
decomposition of the same task. In (b), the number of dependent assertions does not necessarily grow as a function of the number of assumptions in the local level, while in (a) it does. Further, in (a), two independent assumptions are being pursued. These assumptions could potentially be inferred in separate subtasks in an alternate decomposition. In (b),
on the other hand, the assumptions in the subtask are closely **tied together in terms of**
their dependencies and thus better asserted within the same subtask. Because the dependencies of assumptions 1 and 2 **have considerable overlap in (b), Assumption Justification**
pays a high overhead cost to track individual assumptions because (most) everything in the local subtask would be removed simultaneously if assertions B, C, or D changed. Because DHJ incurs no such overhead, DHJ is a better choice when **the intersection between**
assumption dependencies is high. Task knowledge structured more like the situation in
(b), rather than (a) would lead to few unnecessary **retractions. Because (b) appears to** better reflect well-decomposed tasks, Dynamic Hierarchical Justification will constrain the knowledge development process and improve the resulting decompositions. Consequently, nearly-decomposed tasks should allow DHJ to avoid most unnecessary regenerations while avoiding the processing overhead of Assumption Justification.

## 3.4.2 Limiting Persistence Under Dhj

DHJ limits persistence in subtasks, resulting in assumptions that are not as persistent as assumptions in typical truth maintenance systems. This section explores the consequences of these limitations to determine if DHJ architectures4**can still provide the persistence**
necessary for agent execution (Section 2.1).

DHJ will retract a subtask when a potential inconsistency could impact hypothetical and recursive reasoning like counting. Consider the aircraft classification and counting example. Perhaps an aircraft's altitude contributes to a hypothetical classification of the aircraft (e.g., particular altitude and speed combinations might suggest a reconnaissance aircraft).

The agent would create assumptions locally that depend on this aircraft's altitude. If the altitude (or an altitude boundary) changes, then the assumption should be retracted. This retraction is required to avoid inconsistency. If the contact's altitude no longer suggests that it is a reconnaissance aircraft, then the assumption that depended on that assertion should be removed. DHJ captures these dependencies and performs the retraction. The agent now