has the opportunity to reconsider the classification of the aircraft, or pursue other tasks if the classification is no longer important.

DHJ will also retract a subtask if an assumption was created in the local subtask for the purpose of remembering some input (or elaboration of input). For example, if an agent needed to remember a particular aircraft's altitude at a particular point in time, then that assumption cannot be stored in a local subtask. DHJ limits persistence in such a way that remembering within **a local subtask is generally impossible.**
In order to remember previous situations, assumptions can be asserted in the root task.

Any assumption asserted in this level will never be retracted because there are no higher level dependencies (assuming percepts are associated with the top level and not a higher "input level," as in Theo, Mitchell et al., 1991). The primary drawback of this requirement for remembering is that remembered items are no longer local to the subtask that created them, requiring additional domain knowledge to manage remembered assumptions. However, remembering already requires domain knowledge; it is not possible to remember an assertion regardless of its dependencies and also be able to retract it **architecturally.**
These examples show that Dynamic Hierarchical Justification still allows all forms of persistence, but trades capturing dependencies for nonmonotonic assumptions in local subtasks with remembering assumptions in the root task, where no dependencies are captured.

Because DHJ forces remembered items into the root task, it also suggests that a fundamental aspect of this root task should be managing these remembered assumptions. We view this requirement as a positive consequence of DHJ, because it forces knowledge engineers to better recognize the reasons for creating an assumption (e.g., remembering vs. a hypothetical) and circumscribes remembering so that we can now develop or adopt functional or temporal theories to manage assumptions created for remembering (e.g., Allen, 1991; Altmann & Gray, 2002).

## 3.4.3 Recovery From Interruption With Dhj

Dynamic Hierarchical Justification makes an agent more reactive to its environment, ensuring that relevant changes in the environment lead to the retraction of any dependent subtasks. DHJ imposes an automatic interruption of the agent for a subtask retraction, without evaluating the state of the system first. Although automatic interruption increases the reactivity of the system, it can lead to difficulties if there is no way to override it. In this section we examine two cases where uncontrolled interruption can cause problems.

The problems arise because DHJ biases the system to be reactive; that is, to respond automatically to changes in the environment without deliberation. However, in both cases, additional agent knowledge can overcome that bias and make the system more deliberate and avoid uncontrolled interruption.

The first problem arises when there is a sequence of actions that must be completed without interruption in order for a subgoal to be achieved. If the processing is interrupted, then it is possible, because of the dynamics of the world, that the task cannot be resumed. For example, imagine an aircraft nearing the point where it can launch a missile at a target. When the task is interrupted and then resumed, the aircraft's position may have changed enough, relative to the target, that additional steering commands are necessary before the