missile can be launched. In this case, it may be preferable not to interrupt the original launch sequence once it has begun.

Consider two possible approaches to achieving this capability with Dynamic Hierarchical Justification architectures. The first is to move the processing to the root task. Because the root task is not interrupted, the processing will not be interrupted. However, this approach greatly restricts how a task can be hierarchically **decomposed and thus should be** considered only as a last resort. The second approach is to add new reasoning for the task that "freezes" the external situation with respect to additional reasoning in the subtask. The new processing initiates the execution of the subtask and creates persistent structures in the root task. These persistent structures represent a deliberate commitment to not being interrupted. The remaining processing in the subtask **accesses only these structures** in the execution of the task. Thus, because they are persistent, even if there are changes to the surrounding situation that would have interrupted the subtask, its processing is now insensitive to those changes and interruption is prevented. This approach also requires additional reasoning to recognize completion of the uninterruptible behavior and remove the persistent structures built by the initial subtask. This reasoning reflects a deliberate act, signaling that the commitment no longer holds. In the abstract, together these additions provide a mechanism for overcoming automatic interruption. The disadvantage of this approach is that, as part of the system design, those subgoals that cannot be interrupted must be identified beforehand. For those subtasks, additional agent knowledge must be implemented to create and remove encapsulations of any dynamic data.

A more critical problem for DHJ is the "Wesson Oil" problem: when someone is cooking dinner and a higher-priority activity suddenly occurs (a hurt child), the cook should turn off the stove (a "cleanup" procedure) before leaving for the hospital (Gat, 1991b). This problem occurs when there is a change in the hierarchical context at a **level far from the terminal** level of the hierarchy. In this situation, similar tasks may **not be resumed or initiated** following the interruption. The agent must therefore recognize whether "cleanup" of the external and/or internal states is necessary, and, if so, perform that cleanup. Even with DHJ, the agent can still behave appropriately if it has the right knowledge. In particular, the agent must be able to recognize partially completed tasks (like cooking dinner) and be able to select cleanup actions specific to the task state (like turning off a stove burner). Because DHJ requires all remembered assumptions to be asserted in the root level of the hierarchy, this recognition task has internal state available; it need not try to reconstruct that state from the external environment alone. However, it **does require some analysis** of the task domain(s) by a knowledge engineer so that any interruptible activity requiring cleanup include triggering assertions for cleanup in the root task.

This work was prompted by a desire for architectural solutions to inconsistency, yet maintaining consistency efficiently can lead to interruptions, which, under DHJ, requires knowledge-based solutions to problems arising from automatic interruption.5 **However, most**
of the requirements imposed by DHJ are positive consequences. Subtask retractions and observed recovery in the development process help define what must be remembered in the root task for cleanup, which is significantly different than the laborious process of debugging