much more difficult to solve - and thus more costly - as the complexity of an agent's knowledge grows. Although this problem can be solved through careful design of agent knowledge, such an approach requires an understanding of all possible interactions in the hierarchy. Thus, the correctness of this solution depends on the skill and vigilance of the knowledge engineer. Our bias is to seek solutions in which the operation of an agent's primitive memories and processes are structured to ensure inconsistencies do not arise. Thus, we will prefer architectural solutions to knowledge-based **ones. Architectural solutions can** guarantee consistency for all tasks and domains, reducing brittleness due to omissions in task knowledge. Further, while developing an architectural solution may be costly, it should be less costly than repeatedly developing knowledge-based **solutions for different domains.**
The following sections describe the inconsistency problem **and introduce a space of**
solutions to the problem, including two novel solutions. Through both theoretical and empirical analysis, one of the new solutions, Dynamic Hierarchical Justification**, is shown**
to provide an efficient architectural solution to the problem **of ensuring reasoning consistency** in hierarchical execution.

## 2. Maintaining Reasoning Consistency In Hierarchical Agents

This section describes the inconsistency problem in greater detail. We review methods for ensuring consistency in non-hierarchical systems and discuss the limitations of these approaches in hierarchical systems.

## 2.1 Consistency In Non-Hierarchical Systems

Truth maintenance systems (TMSs) are often used to maintain **consistency in non-hierarchical systems (Doyle, 1979; McDermott, 1991; Forbus & deKleer, 1993). An inference engine**
uses domain knowledge to create two different kinds of assertions of knowledge in an agent's knowledge base: assumptions and entailments. The inference engine enables **assumptions**
that it has decided to treat as being true, without requiring **that the assertion be justified. Agents often treat environmental percepts as assumptions or "unquestioned beliefs"**
(Shoham, 1993). Entailments are justified assertions. A data structure, the **justification**, captures the reasons for asserting the entailment. When the **reasons no longer hold (the**
entailment is no longer justified), the TMS retracts it from the set of asserted beliefs. Thus, a TMS automatically manages the assertion and retraction of **entailments as an agent's** situation changes, ensuring all entailments are consistent with the external environment and the enabled assumptions.

Careful construction of the domain knowledge is required to **ensure that no enabled**
assumptions are contradictory. For example, if some assumption is inconsistent with the current input, then the agent must have domain knowledge that recognizes the situation and removes the assumption. Thus, when an agent utilizes a TMS, the problem of maintaining consistency in reasoning is largely one of managing assumptions through the agent's domain knowledge.

Assumptions often reflect hypothetical reasoning about the **world (hence "assumptions"). However, assumptions can be used to represent any persistent feature. Although**
researchers have explored structuring the external environment to provide persistent memory (Agre & Horswill, 1997), internal, persistent memory is **usually necessary in agent**