
## 4.3.2 Performance Differences

Somewhat surprisingly, overall performance of the DHJ agents (measured in CPU time) improves slightly in comparison to the FHJ agents, even though **both decisions and production**
firings increase. Each of the Soar-specific performance metrics are considered individually below, and then the overall performance improvement is considered.

Decisions: FHJ agents, on average, made considerably fewer decisions **than DHJ agents.**
The difference was consistent across every task. These additional decisions result from the removal and subsequent regeneration of subtasks. For example, when the agent picks up a block in pursuit of a stack **task, the selection of the** stack **task must be regenerated. The**
knowledge in the DHJ agents could be modified to avoid testing **specific configurations of** blocks and thus avoid many of these regenerations.

Production Firings**: The number of production firings also increased in the Blocks World.**
The increase in production firings can be attributed to the knowledge added to the system and the regeneration of subtasks that made the additions necessary. The relative increase in number of production firings (19%) was much smaller than the increase in decisions (62%). The smaller difference can be attributed to the productions that were removed (and thus did not fire).

CPU Time**: Generally, when production firings increase in Soar, an increase in CPU**
time is expected. However, CPU time in DHJ decreased slightly in comparison to FHJ
even though production firings increased. To explain this result, some additional aspects of Soar's processing must be considered.

The match cost of a production is not constant but grows linearly with the number of tokens**, partial instantiations of the production (Tambe, 1991). Each token indicates what**
conditions in the production have matched and the variable bindings for those conditions. Thus, each token represents a node in a search over the agent's memory for matching instantiation(s) of the production. The more specific a production's conditions are, the more constrained the search through memory, and thus it costs less to generate the instantiation.

The new productions added to the DHJ Blocks World agent were more specific to the agent's memory (i.e., its external and internal state) than the productions removed. Further, simply having fewer total productions also can reduce the amount of total search in memory.6 **An informal inspection of the match time and tokens for several FHJ and**
DHJ runs showed that the number of tokens decreased in DHJ by 10-15%. This reduction in token activity is the primary source of improvement in Dynamic Blocks World DHJ
agent CPU time. This improvement, of course, is not a general **result and provides no**
guarantee that in some other task or domain the cost of matching will not increase rather than decrease.