
## 4.4 Empirical Evaluation In Μ**Tacair-Soar**

Converting TacAir-Soar to the DHJ architecture would be very expensive, requiring many months of effort. DHJ agents were instead developed for a research and instruction version of TacAir-Soar, "Micro-TacAir-Soar" (µTAS). µ**TAS agents use the TacAir-Soar simulation**
environment (ModSAF) and interface but have knowledge to fly **only a few missions, resulting in an order of magnitude decrease in the number of productions in the agents. However,**
µ**TAS uses the same tactics and doctrine for its missions as TacAir-Soar.**
In µ**TAS, a team of two agents ("lead" and "wing") fly the patrol mission described**
previously. They engage any hostile aircraft that are headed toward them and are within a specific range. The lead agent's primary role is to fly the patrol route and intercept enemy planes. The wing's responsibility is to fly in formation with the lead. Because the total knowledge is significantly reduced, converting µ**TAS DHJ agents should be relatively**
inexpensive. However, the results should be representative of TacAir-Soar because µTAS
retains the complexity and dynamics of TacAir-Soar.

The patrol mission has no clearly-defined task termination condition like the Dynamic Blocks World. To address this problem, each agent in the simulation executes for ten minutes of simulator time. During this time, each agent has the opportunity to take off, fly in formation with its partner on patrol, intercept one enemy agent, and return to patrol after the intercept. In an actual TacAir-Soar scenario, these activities would normally be separated by much larger time scales. However, an agent spends much of its time on a patrol mission simply monitoring the situation (waiting), **rather than taking new actions.**
Ten minutes of simulated time proved to be brief enough that overall behavior was not dominated by wait-states, while also providing time for a natural flow of events.

When running for a fixed period of time, an increase in the number of decisions can be attributed to regeneration or simply an improvement in decision cycle time. We avoid this potential confusion by running the simulator with a constant cycle time. In this mode, each simulator update represents 67 milliseconds of simulated time. Because each agent now runs for a fixed period of time with fixed updates, each FHJ and DHJ agent will execute the same number of decisions. Any problems due to regeneration will be apparent in the number of rule firings and degradation in responsiveness. Additionally, the general results do not change significantly if the scenarios are executed with the real-time mode normally used for TacAir-Soar agents. The fixed cycle simply eliminates some variability.

Although the patrol scenario was designed to minimize variation from run to run, the µ**TAS simulator is inherently stochastic and the specific actions taken by an agent and the**
time course of those actions varies when the same task is repeated. To control for this variation, each scenario was run for the lead and wing agents approximately 50 times. Logging and data collection significantly impacted CPU time and other performance statistics. In order to control for this effect, we actually ran each scenario 99 times, randomly choosing one agent (lead or wing) to perform logging functions (and discarding its performance measures). The other agent performed no logging functions. Data from logging agents was used to create Figure 9. The performance measures of the "no logging" agents were recorded at the conclusion of each scenario and are summarized in Table 2.