command may be issued again because the agent cannot recognize that the command has already been issued by another subtask. Because motor commands are remembered in the top subtask by DHJ agents, they can be inspected by all subtasks. The DHJ wing thus never issues a redundant motor command. The large relative decrease in outputs in the wing agent from FHJ to DHJ (Figure 11) can be attributed to this improvement. Production firings decrease with the decrease in output activity because most reasoning activity in the wing concerns reacting to the lead's maneuvers.

In contrast to the wing, the lead's average number of outputs **actually increases. Regeneration is the source of these additional outputs. In a few situations, a DHJ agent's**
subtask for adjusting heading, speed or altitude can get updated repeatedly in a highly dynamic situation (e.g., a hard turn). The FHJ agent uses subtask knowledge to decide if the current output command needs to be updated. However, in DHJ, the subtask may be retracted due to dependence on a changing value (e.g., current heading). When the subtask is regenerated following a retraction, the lead may generate a slightly different motor command. For example, the lead might decide to turn to heading 90.1Æ**instead of 90.2**Æ. This decision causes the generation of a new output command that would not have been re-issued in FHJ agents and accounts for the small increase in outputs. It also suggests that without the self-imposed constraint of the methodology, the knowledge base could be further modified to avoid this regeneration and further decrease production firings.

Although the large magnitude of the improvement in the wing is primarily due to remembering motor commands, both agents also needed less consistency knowledge and thus accessed less knowledge while performing the same task. The **agents perform the same tasks** using less knowledge.

CPU Time**: CPU time decreases in both the DHJ lead and wing agents. The improvement**
in the lead (39%) is about half the improvement in the wing (81%). These differences are due primarily to the decrease in production firings. There are fewer production firings and thus fewer instantiations to generate, leading to improvements **in CPU time. Match time also**
improved, contributing to the overall performance improvement.9 **The larger improvements**
in CPU time as compared to production firings improvements (39% vs. 15% in the lead, 81% vs. 62% in the wing) might be attributable to decreases in **both the number of rule**
firings and match time. Again, these results offer no guarantee that match time will always decrease with DHJ. It is important to note, however, in two very different domains DHJ
reduces total knowledge and further constrains the remaining knowledge. The architecture then leveraged these small differences for improved overall **performance.**

## 4.4.5 Differences In Responsiveness

Because CPU time decreases in the DHJ agents, responsiveness should generally improve. However, because some agent knowledge has been split into several different subtasks, some actions may not be initiated as quickly as would be initiated **by the FHJ agent. In this** section, we explore differences in responsiveness in one of these situations.