
| Avg. In-Range Time   | Avg. Launch Time   | Reaction Time   |      |    |
|----------------------|--------------------|-----------------|------|----|
| (sec)                | (sec)              | (sec)           | n    |    |
| FHJ                  | 161.816            | 162.084         | .268 | 95 |
| DHJ                  | 162.048            | 162.993         | .945 | 99 |

When an enemy plane comes in range, the agent executes a series of actions, leading to the firing of a missile. Reaction time **is the difference between the time at which an enemy**
agent comes in range and the time when the agent actually pushes the fire button to launch a missile. This reaction time is one measure of the agent's responsiveness. As Table 4 shows, the FHJ agent is able to launch the missile in just over a quarter of a second. However, the DHJ agent is about three-and-a-half times slower than the FHJ agent in launching the missile, taking almost a full second, on average.

Split subtasks, regeneration, and subtask selection all contribute to the increase in reaction time. Splitting a subtask with n **steps, which may have all been executed in a** single decision previously, may now take n **decisions in the DHJ agent. Only a few actions**
are necessary for launching a missile so one would expect an increase of, at most, a few hundred milliseconds for this change. However, by dividing **subtasks into separate steps,** the sequential series of actions can be interrupted. In particular, a number of regenerations occur under the launch-missile **subtask as the agent prepares to fire the missile in a highly** dynamic situation. The agent sometimes chooses to undertake a similar action because the situation has changed enough that a slightly different action might be necessary, as described above. The result is that the DHJ agents are taking more accurate aim than the FHJ agents, as they are responding more quickly to the dynamics of the environment. This "aiming," however takes more time, although the increase in time is not **tactically significant (i.e.,**
enemy planes were not escaping that were previously hit by FHJ agents).

Some additional re-engineering of the knowledge would improve the reaction time (e.g.,
as described in Section 3.4.3). However, decreases in responsiveness will be difficult to avoid, in general. Dynamic Hierarchical Justification requires that subtasks with different dependencies be initiated and terminated separately, or risk unnecessary regeneration. However, by splitting complex tasks into separate subtasks, individual actions are delayed both because the subtasks are now separate procedures, and because **the selection for a particular**
subtask in the series can be postponed when additional subtask choices are available.

## 4.5 Summary Of Empirical Evaluations

Figure 12 summarizes results from the Dynamic Blocks World and µ**TAS. In both domains,**
DHJ agents require fewer total productions, suggesting a decrease in knowledge cost. Performance is roughly the same in the Dynamic Blocks World and for the lead agents in µ**TAS.**
The DHJ wing agents show a much greater improvement in overall performance, which is due both to DHJ and to changes in knowledge. These results suggest that Dynamic Hierarchical Justification can be expected to reduce engineering effort and not degrade performance in a variety of domains, simple and complex. However, response **time in some situations may**
decrease.