Another possible limitation would be to restrict all assumptions to a single memory
(global state), or, equivalently, allow assumptions only in the root level of the hierarchy in a hierarchical architecture. This solution ensures that **the hierarchical context is always** consistent (all assertions within an associated subtask are entailments) and also allows persistence. Because HTN execution systems such as RETSINA **and DECAF, mentioned** previously, have only a global state, they obviously do not suffer from inconsistency over a hierarchy. However, the interactions between persistent **assertions and new information** derived from sensors will be a problem in systems with global **state.**
RETSINA has recently adopted rationale-based monitoring **(Veloso, Pollack, & Cox,**
1998) to identify environmental changes that could impact a currently executing task network (Paolucci et al., 1999). Rationale-based monitoring uses the structure of plan knowledge (in this case, plan operators, including task networks) to alleviate inconsistency. Monitors for relevant world features are created dynamically as **planning progresses by identifying**
pre-conditions in operators and instantiating them via a straightforward taxonomy of monitor types (e.g., a monitor for quantified conditions). The collection of monitors form a **plan**
rationale**, "reasons that support a planner's decisions" (Veloso et al., 1998). Plan rationales**
are thus similar to the justifications used in truth maintenance. Monitors are activated when a pre-condition element in the world changes. They then **inform the planner of the**
change, and the planner can then deliberate about whether the change should impact the plan under construction and, if so, consider appropriate repairs.

Rationale-based monitoring is similar to Dynamic Hierarchical Justification, especially because they both leverage the structures of their (different) underlying task representations to provide consistency. However, there are two important differences. First, because DHJ identifies the specific subtask impacted by a change, it does not require deliberation to determine the impact of the change; immediate return to a consistent knowledge state is possible. When a monitor is activated in rationale-based **monitoring, the planner must** first determine where and how the plan is affected, which can require deliberation. Second, because monitors trigger deliberation, rather than automatically retracting reasoning, an agent using rationale-based monitoring can determine if the plan should be repaired and how. DHJ (as implemented) does not offer this flexibility; retraction is automatic. Automatic retraction assumes the cost of retrieving (or regenerating) pre-existing plan knowledge is less costly than deliberation to determine if/how the plan can be revised. Because plan modification can be as expensive as plan generation (Nebel & Koehler, 1995), this assumption is reasonable. However, invoking a deliberate revision process could circumvent potential problems arising from recovery from interruption (Section 3.4.3).

## 5.1.2 Fixed Hierarchical Justification

As mentioned previously, both the pre-DHJ version of Soar and the Procedural Reasoning System (PRS) (Georgeff & Lansky, 1987) use Fixed Hierarchical Justification to retract complete levels of the hierarchy when the support set no longer holds. In PRS, the support set consists of a set of context elements that must hold during the execution of the subtask. These elements are defined by a knowledge engineer. Fixed Hierarchical Justification offers a complete solution to the inconsistency problem if context references within the reasoning in a subtask are limited to the support set. This approach guarantees consistency. However,