it requires that the knowledge designer identify all potentially relevant features used in reasoning within the subtask. Additionally, the resulting **system may be overly sensitive**
to the features in the support set if those features only rarely impact reasoning, leading to unnecessary regeneration.

Fixed Hierarchical Justification requires less explicit consistency knowledge than knowledgebased solutions. However, KBAC knowledge is still required **if access to the whole task hierarchy is possible. Thus, an agent's ability to make subtask-specific reactions to unexpected**
changes in the environment is limited by the knowledge designer's ability to anticipate and explicitly encode the consequences of those changes.

## 5.2 Intention Reconsideration

In the belief-desire-intention (BDI) model of agency, an intention represents a commitment to achieving a goal (Rao & Georgeff, 1991; Wooldridge, 2000). **An intention is thus similar** to the instantiation of a subtask in a hierarchical architecture.

Dynamic Hierarchical Justification can be viewed as a partial implementation of intention reconsideration **(Schut & Wooldridge, 2000, 2001). Intention reconsideration is the** process of determining when an agent should abandon its intentions (due to goal achievement, recognition of failure, or recognition that the intention itself is no longer desired). Dynamic Hierarchical Justification is only a partial implementation of intention reconsideration because it is only able to capture syntactic features of the problem solving (i.e.,
the identification of dependencies via the support set) to determine when to reconsider an intention. Situations that require deliberation to determine that an intention should be abandoned are not captured in DHJ.10 **Schut & Wooldridge (2001) describe an initial attempt to allow the run-time determination of reconsideration policies. An optimal policy**
would maximize the likelihood that deliberate intention reconsideration actually leads to abandoning an intention (i.e., the agent reconsiders when reconsideration is necessary). In contrast, Dynamic Hierarchical Justification offers a low-cost, always available, domain general process for abandoning intentions, but cannot automatically identify reconsiderations requiring semantic analysis of the problem state.

In BDI models, agents can choose to execute their current action plans with or without reconsidering their current intentions first. Kinny and Georgeff (1991) showed that, in more static domains, "bold" agents that never reconsider their intentions perform more effectively than "cautious" agents that always reconsider before executing a plan step. The opposite is true in highly dynamic domains: "cautious" agents out perform "bold" ones. Both Soar and PRS can be described as being cautious via Fixed Hierarchical Justification. That is, at each plan step, the architectures determine if elements in the support set remain asserted before executing the step. FHJ approaches are, in effect, more "bold" than they appear, because they do not reconsider intentions when assertions have changed in the dependent context, but not in the support set. Dynamic Hierarchical Justification provides more
"cautious" agents, because it ensures that the agent's reconsideration function takes into account all context dependencies for subtask reasoning. From the perspective of intention