compute belief updates via incremental derivations of a belief state, rather than via belief revision (Kurien & Nayak, 2000).

The power of the heuristic approach used by DHJ over the analytic solution follows from the characteristics outlined in Section 3.4.1: the hierarchical structure and organization of the agent assertions and the efficiency of the underlying reasoning system to regenerate any unnecessarily removed assertions. Assumptions (persistent beliefs) are associated with particular subtasks in hierarchical architectures. A change in perception (an epistemic input)
leads to a revision. Rather than determining the minimal revision, DHJ uses a heuristic that, in this context, says that persistent beliefs in a subtask have similar epistemic entrenchment to the subtask/intention itself. In some cases, **this heuristic will be incorrect,** leading to regeneration, but, when correct, it provides a much simpler mechanism for revision. G¨ardenfors (1988) anticipates such conclusions, **suggesting that systems possessing**
additional internal structure (as compared to the the relatively unstructured belief sets of AGM theory) may provide additional constraints for orderings of epistemic entrenchment.

## 6. Conclusion

The empirical results from both the Dynamic Blocks World and µ**TAS domains were consistent with expectations: knowledge engineering cost decreased and overall performance in**
DHJ was roughly the same (or slightly improved) in comparison to independently-developed FHJ benchmarks. Development cost decreases because the designer is freed from the task of creating across-level consistency knowledge. One drawback of DHJ is that responsiveness can degrade when regeneration occurs.

DHJ has been incorporated into the currently released version of Soar (Soar 8) for over 3 years and the experience of users further confirms that development cost decreases. It is partly true that developers need a deeper understanding of the architecture to realize this benefit. However, DHJ removes the need for the encoding of across-level consistency knowledge, which has proven difficult to understand and encode in many systems. DHJ also makes understanding the role of assumptions in Soar systems **more straightforward, by imposing design and development constraints. For instance, the knowledge designer must now**
think about why, when, and where persistence should be used in the agent. Once the knowledge designer determines the functional role of some persistent assumption, DHJ guides the development of the knowledge necessary for that assumption. For a nonmonotonic or hypothetical assumption, no knowledge must be created that "looks outside" the subtask in order to ensure consistency (i.e., no across-level knowledge is necessary). Assumptions for remembering must be asserted in the root level of the hierarchy, and knowledge must be created to manage the remembered assumption. Functions of the root task now include monitoring, updating, and removing remembered assumptions (we are developing domaingeneral methods for managing these remembered assumptions **to further reduce cost). Thus,**
while DHJ does increase the complexity of the architecture, **it makes design decisions more** explicit and manageable than previous KBAC approaches.

Regeneration, seemingly one of the drawbacks of DHJ, also contributes to decreased knowledge development costs. Regeneration serves as a debugging tool, allowing immediate localization of problem areas in the domain knowledge (and its specific decomposition).

This debugging aid contrasts with previous knowledge development in which inconsistency