often became evident only in irrational behavior, making it **often difficult to determine the**
actual source of a problem. Thus, in addition to reducing total knowledge necessary for some task, Dynamic Hierarchical Justification might also reduce the cost per knowledge unit when creating agent knowledge by localizing problems via regeneration. However, if it is the case that some domain cannot be decomposed into nearly decomposable subunits, regeneration could be debilitating.

Another positive consequence of DHJ is that an agent may behave more robustly in novel situations not anticipated by the knowledge engineer. For example, as a simple experiment, the FHJ and DHJ Dynamic Blocks World agents were placed in the **situation described in**
Figure 3. The FHJ agent fails when the block moves because it lacks knowledge to recognize moving blocks; the knowledge designer assumed a static domain. With the same knowledge, however, the DHJ agent responds to this situation gracefully. In the specific situation in Figure 3, the DHJ agent immediately retracts the put-on-table(3) **subtask, because**
block-3 **is on the table, and thus the selection of that subtask is no longer consistent with**
the current situation. The agent then chooses stack(2,3) **and decomposes this subtask**
into actions to put block-2 on block-3. If a new block (e.g., block-4**) is placed in the**
empty space below block-2**, the architecture responds by retracting the subtask goal for**
put-down(2) **(i.e., the subtask that contains the** empty **assumption). It then begins to search**
for empty spaces in order to continue its attempt to put block-2 **on the table. Because the**
architecture, rather than agent knowledge, ensures consistency across the hierarchy, DHJ agents should be less brittle in situations not explicitly anticipated in agent design.

DHJ also provides a solution to the problem of learning rules **with non-contemporaneous**
constraints (Wray, Laird, & Jones, 1996). Non-contemporaneous constraints arise when temporally distinct assertions (e.g., red light, green light) are collected in a single learned rule via knowledge compilation. A rule with non-contemporaneous constraints will not lead to inappropriate behavior but rather will never apply. This **problem makes it difficult to** use straightforward explanation-based learning approaches to operationalize agent execution knowledge. Non-contemporaneous constraints arise when the architecture creates persistent assumptions that can become inconsistent with the hierarchical context (Wray et al., 1996). Because DHJ never allows such inconsistency, it solves the non-contemporaneous problem.

For instance, agents in both the Dynamic Blocks World and µ**TAS were able to learn**
unproblematically in the new architecture, with no/little **knowledge re-design. Wray (1998)** provides additional details and an empirical assessment of **the learning.**
Dynamic Hierarchical Justification operates at a higher level of granularity than Assumption Justification or knowledge-based solution methods, trading fine-grained consistency for lower computational cost. This higher level of abstraction does introduce additional cost in execution. In particular, necessary regeneration led to some redundancy in knowledge search in both the Dynamic Blocks World and µ**TAS agents. Although overall efficiency improved, some of the improvement was due to improvements in the average**
match cost of productions, which cannot be guaranteed in all **domains or in other architectures. Further, Dynamic Hierarchical Justification requires that complex subtasks be**
split into distinct subtasks. This requirement improves the knowledge decomposition and reduces regeneration in performance but can reduce responsiveness. However, with the straightforward compilation of reasoning in subtasks that **DHJ enables, the reduction in**
responsiveness can be overcome with learning (Wray, 1998).