Although the implementation and evaluation of DHJ was limited to Soar, we attempted to reduce the specificity of the results to Soar in two ways. First, we identified the problems that across-level consistency knowledge introduces in knowledge-based approaches: it is expensive to develop, degrades the modularity and simplicity of the hierarchical representation, and is only as robust as the knowledge designer's **imagination. When agents are**
developed in sufficiently complex domains, the expense of creating this knowledge will grow prohibitive. This cost may lead additional researchers to consider architectural assurances of consistency. Second, Dynamic Hierarchical Justification gains its power via the structure of hierarchically decomposed tasks. Although specific implementations may differ for other agent architectures, the heuristic simplifications employed by DHJ should transfer to any architecture utilizing a hierarchical organization of memory for task decomposition. Dynamic Hierarchical Justification is an efficient, architectural solution that ensures reasoning consistency across the hierarchy in agents employing hierarchical task decompositions. This solution allows agents to act more reliably in complex, dynamic environments while more fully realizing low cost agent development via hierarchical task decomposition.

## Acknowledgments

This work would not have been possible without those who contributed directly to the development and evaluation of Dynamic Hierarchical Justification. Scott Huffman, John Laird and Mark Portelli implemented Assumption Justification in Soar. Ron Chong implemented a precursor to DHJ. Randy Jones, John Laird, and Frank Koss developed µ**TacAirSoar. Sayan Bhattacharyya, Randy Jones, Doug Pearson, Peter Wiemer-Hastings, and**
other members of the Soar group at the University of Michigan **contributed to the development of the Dynamic Blocks World simulator. The anonymous reviewers provided valuable,**
constructive comments on earlier versions of the manuscript. This work was supported in part by a University of Michigan Rackham Graduate School Pre-doctoral fellowship, contract N00014-92-K-2015 from the Advanced Systems Technology Office of DARPA and NRL, and contract N6600I-95-C-6013 from the Advanced Systems Technology Office of DARPA and the Naval Command and Ocean Surveillance Center, RDT&E division. Portions of this work were presented at the 15th **National Conference on Artificial Intelligence**
in Madison, Wisconsin.

## Appendix A: Improving Task Decompositions

This appendix describes in detail the changes that were made to the µ**TAS agent knowledge**
for DHJ.

Remembering: **Figure 4 showed an agent computing a new heading as a subtask of the**
achieve-proximity subtask. This calculation usually depends upon the current **heading.** When the agent generates the command to turn, the heading changes soon thereafter. In this situation, the DHJ agent must "remember" that it has already made a decision to turn to a new heading by placing the assumption that reflects the new heading in the top level. If it places the assumption in the local level, then the new current heading will trigger the removal of turn-to-heading **and then regeneration of the subtask (if the agent determines**
that it still needs to turn to some new heading).