In the FHJ agents, all output commands (such as turn to some specific heading) were asserted as assumptions in the local subtask. The DHJ agent's knowledge was changed to issue output commands directly to the output interface (which, in Soar, is always part of the highest subtask in the hierarchy). No unnecessary regeneration now occurs because the agent remembers all motor commands and generates a new one only when a different output is necessary. This change, of course, requires consistency knowledge because the motor commands are unjustified and thus must be explicitly removed, as is true for any remembered knowledge with DHJ.

Within-level Consistency Knowledge: **Dynamic Hierarchical Justification, like all solutions to the across-level consistency problem, still requires consistency knowledge within**
an individual subtask. Some of this knowledge in the FHJ agents is used to remove intermediate results in the execution of a subtask. This "clean up" knowledge allows the agent to remove local assertions that contributed to some terminating subtask and thus avoid the
(mis)use of these assertions in later reasoning.

As an example, consider the achieve-proximity **subtask. This subtask is used in**
a number of different situations when an agent needs to get closer to another agent. If the wing strays too far from the lead, it may invoke achieve-proximity **to get back into**
formation with the lead. The lead uses achieve-proximity **to get close enough to an enemy** aircraft to launch a missile. The subtask requires many local computations as the agent reasons about what heading it should take to get closer to another aircraft. The specific computation depends on what information is available about **the other aircraft. When the** wing is pursuing the lead, it may know the lead's heading and thus calculate a collision course to maximize the rate of convergence. Sometimes the other agent's heading is not available. In this case, the agent simply moves toward the current location of the other agent. These local computations are stored in the local subtask. When achieve-proximity is terminated in the FHJ agent, the agent removes the local structure. Removing the structure is important both because it interrupts entailment of the local structure (e.g., calculation of the current collision course) and guarantees that if the agent decides to achieve-proximity with a different aircraft, supporting data structures are properly initialized. This knowledge thus maintains consistency in the local subtask by removing **the local structure when the**
achieve-proximity **subtask is no longer selected.**
The FHJ agent could recognize when it was going to remove a subtask. The termination conditions in FHJ agents acted as a signal to the within-level consistency knowledge. The knowledge that removes the local structure for achieve-proximity **can be summarized as:**
"if the achieve-proximity **operator is selected, but its initiation conditions no longer hold,**
then remove the local achieve-proximity **data structure." Thus, the FHJ agent uses a** recognition of an inconsistency in the assertions to trigger the activation of this within-level consistency knowledge.

When the subtask's initiating conditions are no longer supported in the DHJ agents, the selected subtask is removed immediately. Thus, the DHJ agent never has the opportunity to apply the FHJ agent's within-level consistency knowledge. The failure to utilize this knowledge led to a number of problems, including more regenerations than expected.

To solve this problem, the local subtask data structure was created as an entailment of the initiation conditions of the subtask itself. When the subtask initiation conditions no longer held, both the subtask selection and the local structure are immediately removed by