the architecture, requiring no additional knowledge. Thus, this change obviated the need for some within-level consistency knowledge. However, the **local data structure may need**
to be regenerated if a subtask is temporarily displaced. For **instance, the FHJ within-level** consistency knowledge could determine under what conditions the local structure should be removed. The DHJ solution has lost that flexibility.

Subtasks with Complex Actions: **FHJ agents can execute a number of actions in rapid**
succession, regardless of any inconsistency in the local assertions. A single subtask operator can be initiated in a situation representing the conditions **under which to apply the first**
action in a sequence, and terminated when the last step in the **sequence has applied. If** some intermediate step invalidates the initiation conditions, the subtask still executes the actions.

Consider the process of launching a missile. An actual missile launch requires only the push of a button, assuming that previous steps such as selecting the target and an appropriate missile have been accomplished beforehand. After pushing the fire button, the pilot must fly straight and level for a few seconds while the missile rockets ignite and launch the missile into flight. Once the missile has cleared the aircraft, the agent "supports" the missile by keeping radar contact with the target. In FHJ agents, the push-fire-button subtask includes both the act of pushing the fire button and counting while the missile clears the aircraft. These tasks have different and mutually exclusive dependencies. The initiation condition for push-fire-button **requires that no missile is already launched. However, the**
subsequent counting requires monitoring the newly launched missile.

DHJ agents using the FHJ knowledge base always remove the push-fire-button **subtask as soon as the missile is perceived to be in the air, interrupting the complete procedure.**
Regeneration of the push-fire-button **subtask occurs because the agent never waits for the** missile to clear and thus never realizes that the missile just launched needs to be supported.

The DHJ agent unsuccessfully fires all available missiles at **the enemy plane.**
Pushing the fire button and waiting for the missile to clear are independent tasks which happen to arise in serial order in the domain. We enforced this independence by creating a new subtask, wait-for-missile-to-clear**, which depends only on having a**
newly launched missile in the air. The DHJ agent now pushes the fire button, selects wait-for-missile-to-clear **to count a few seconds before taking any other action, and** then supports the missile if it clears successfully.

This solution reduces regeneration and improves behavior quality but it does have a non-trivial cost. Whenever a subtask is split, the effects of **subtask actions no longer occur** in rapid succession within a decision. Instead, the effect of **the first subtask occurs in one** decision, the effect of the second subtask in the second decision, etc. Thus, this solution can compromise responsiveness.

## References

Agre, P. E., & Horswill, I. (1997). Lifeworld analysis. **Journal of Artificial Intelligence**
Research, 6**, 111–145.**
Alchour´ron, C. E., G¨ardenfors, P., & Makinson, D. (1985). **On the logic of theory change:**
Partial meet contraction and revision functions. Journal of Symbolic Logic, 50**(2),**
510–530.