TMS can readily determine dependent context changes and retract affected entailments.

However, changes in higher levels of the hierarchy (such as those deriving from inputs)
may also invalidate the assumptions of lower levels. Without any additional architectural mechanisms, domain knowledge is required to ensure consistency among assumptions and the hierarchical context as in non-hierarchical systems. The domain knowledge for ensuring consistency in the assumptions is complicated by the necessity of spanning multiple (possibly many) subtasks. We refer to such knowledge as "across-level" consistency knowledge. As described in further detail below, identifying and **creating across-level consistency**
knowledge is a tedious, costly, and often incomplete process. Across-level knowledge must explicitly consider the interactions between different subtasks (in different levels of the hierarchy), rather than focus solely on the local subtask, compromising the benefit of the hierarchical decomposition.

Before continuing, we note that hierarchical architectures should be contrasted with hierarchical task network (HTN) planners (Sacerdoti, 1975; Erol, Hendler, & Nau, 1994)
and execution-oriented systems that use HTN representations, such as DECAF (Graham & Decker, 2000) and RETSINA (Sycara, Decker, Pannu, Williamson, & Zeng, 1996). A
planning problem for an HTN planner is represented by an initial task network that can consist of primitive and non-primitive tasks. The planner uses operators to find a plan to solve the tasks. Methods allow the planner to match non-primitive tasks with other task networks that describe how to accomplish the task; thus, methods enable hierarchical decomposition of the planning problem into a family of connected task networks.

The main difference between HTN systems and hierarchical architectures is that the planner represents its plan in a single global state. That is, while methods represent decomposition steps, the hierarchical structure of an evolving plan is represented in a blackboardlike database that does not also reflect the structure of the decomposition. The following sections discuss problems and especially solutions that depend on the hierarchical organization **of asserted knowledge during execution, in addition to a hierarchical task decomposition encoded as an agent's task knowledge. Thus, the following will not be generally**
applicable to HTN-based execution systems. However, HTN systems need to address the inconsistency problem; Section 5.1.1 examines the consequences of global state with respect to inconsistency arising from persistence in a hierarchy.

## 2.3 Failing To Respond To Relevant Changes In Hierarchical Context

As mentioned in the introduction, when an agent fails to respond to a relevant change in its hierarchical context and leaves a now-inconsistent assumption enabled, the resulting behavior can become irrational; that is, not consistent with its knowledge. This section explores how such irrational behavior can arise with several illustrative examples.

## 2.3.1 The Blocks World

We use a variant of the blocks world to illustrate the inconsistency problem in a domain familiar to most readers. This domain is an execution domain **rather than a planning** domain, which we call the "Dynamic Blocks World" to reflect this difference from the static blocks world used in planning. We assume the agent has knowledge to build an ordered