

![0_image_0.png](0_image_0.png) 
tower (1-on-2-on-3**) without resorting to planning and uses hierarchical task decomposition**
to determine what actions to take as it builds the tower.

In Figure 3, the agent is placing block-2 on the table, in order to reach block-3 and begin the goal tower. The put-down **subtask finds an empty location on the table. The**
agent places the empty **assertion in the memory associated with the** put-down **subtask. In**
the figure, the space immediately to the left of the gripper was chosen. Whether or not a space is empty may not be directly observable but may need to be inferred from a number of other facts in the domain and stored as an assumption in memory. Assume the empty assertion is an assumption. Now, assume block-3 is suddenly placed underneath **block-2**.

The result is an inconsistency between the assumption (the location is a good place to put block-2**) and the hierarchical context (the location is no longer a good place to put the**
block on the table).

If the agent fails to recognize that block-3 has moved, it will attempt to put **block-2**
into the same location occupied by block-3**. This behavior is irrational, or not consistent**
with the agent's goals and knowledge (assuming the agent has **knowledge that indicates**
that blocks should not be placed in positions already occupied by other blocks). The inconsistency arises because the agent has failed to recognize its previously-derived assumption
(empty**) is no longer true in the current situation.**
Although this example may appear contrived, this specific situation arose in an experimental system developed to explore architecture and learning issues. Of course, it is possible in such a simple domain to reformulate the task such that the problem does not occur. This reformulation of the task via changes to or additions of knowledge is exactly **the solution** we wish to avoid. That is, we desire that the architecture guarantee consistency between the hierarchical context and local assumptions such that the architecture provides **a priori** constraints (guidance) in the knowledge development process and increased robustness in execution (via consistency). The conclusion returns to this example to describe how an