
## 3. Solutions

Our goal is to develop architectural solutions that allow an **agent to support persistent** assumptions and simultaneously avoid inconsistencies across the hierarchical context that can lead to irrational behavior. Before introducing two new **architectural solutions, however,** we examine knowledge-based approaches and their consequences in order to provide further rationale for the architectural approach.

## 3.1 Knowledge-Based Solutions

Inconsistency can be avoided in hierarchical agents by creating domain knowledge that recognizes potential inconsistencies and responds by removing assumptions. Many planning and agent systems use explicit domain knowledge to represent knowledge about the interactions among assertions in the world. For example, the Entropy Reduction Engine
(ERE) (Bresina et al., 1993) is one agent system that relies on this knowledge-based assumption consistency (KBAC). ERE requires domain constraints**, or knowledge that describes**
the physics of the task domain. Domain constraints identify **impossible conditions. For**
instance, a domain constraint would indicate that a robot cannot occupy two different physical locations simultaneously.

In ERE, domain constraints are specifically used "to maintain consistency in the current world model state during execution" (Bresina et al., 1993, pp. 166). However, many other architectures use KBAC as well (perhaps in conjunction with **other methods). KBAC**
knowledge can be viewed simply as domain knowledge that must **be added to the system**
to achieve consistent behavior.

KBAC will always be necessary to maintain consistency among **the assumptions within**
a level of the hierarchy. However, in order to guarantee consistency for assumptions distributed throughout the hierarchy, all possible interactions leading to inconsistency must be identified throughout the hierarchy**. This knowledge engineering problem can add significant cost to agent development. A knowledge designer must not only specify the conditions**
under which an assumption is asserted but also all **the conditions under which it must be**
removed. In the TacAir-Soar interception example, when the **enemy plane flees, the agent**
requires knowledge that disables all assumptions that depend upon the number of enemy airplanes. Similarly, in the Dynamic Blocks World, the agent must have knowledge that recognizes any situation, in any subtask, that should cause **the disabling of** empty**. In both**
cases, this KBAC knowledge "crosses" levels of the hierarchy. A complete KBAC solution requires that an agent's knowledge capture all **potential dependencies between assumptions** in a local subtask and any higher levels in the hierarchy.

Although it will be possible to encode complete across-level consistency knowledge for simple domains, experience in TacAir-Soar and other complex agent systems has convinced us that KBAC requires significant investments of time and energy. Further, because it is often not possible to enumerate all conditions under which an assumption must be removed, agents are also brittle, failing in difficult-to-understand, difficult-to-duplicate ways.

The insufficiency of knowledge-based solutions led us to consider architectural solutions to the problem. Architectural solutions eliminate the need **for domain knowledge encoded** only to address inconsistency between the hierarchical context and assumptions within a subtask. Thus, the cost of developing individual agents should be reduced. In addition to