
## 3.1 Wrapper Verification

If the data extracted by the wrapper changes significantly, this is an indication that the Web source may have changed its format. Our wrapper verification system uses examples of data extracted by the wrapper in the past that are known to be correct in order to acquire a description of the data. The learned description contains features of two types: patterns learned by DataProG **and global numeric features, such as the density of tokens**
of a particular type. The application then checks that this description still applies to the new data extracted by the wrapper. Thus, wrapper verification **is a specific instance of the**
data validation task.

The verification algorithm works in the following way. A set of **queries is used to retrieve**
HTML pages from which the wrapper extracts (correct) training examples. The algorithm then computes the values of a vector of features, ~k**, that describes each field of the training**
examples. These features include the patterns that describe the common beginnings (or endings) of the field. During the verification phase, the wrapper generates a set of (new) test examples from pages retrieved using the same set of queries, and computes the feature vector ~r associated with each field of the test examples. If the two distributions, ~k and ~r
(see Fig. 5), are statistically the same (at some significance **level), the wrapper is judged to**
be extracting correctly; otherwise, it is judged to have failed.

![0_image_0.png](0_image_0.png)

![0_image_1.png](0_image_1.png)

Each field is described by a vector, whose ith component is the value of the i**th feature,**
such as the number of examples that match pattern j**. In addition to patterns, we use the** following numeric features to describe the sets of training **and test examples: the average** number of tuples-per-page, mean number of tokens in the examples, mean token length, and the density of alphabetic, numeric, HTML-tag and punctuation types. We use goodness of fit method (Papoulis 1990) to decide whether the two distributions are the same. To use the goodness of fit method, we must first compute Pearson's test statistic for the data. The Pearson's test statistic is defined as: