result in the following precision, recall and accuracy values:

$$\begin{array}{r c l}{{P}}&{{=}}&{{\frac{t r u e\,\,p o s i t i v e s}{t r u e\,\,p o s i t i v e s\,+\,f a l s e\,\,p o s i t i v e s}=0.73\,,}}\\ {{R}}&{{=}}&{{\frac{t r u e\,\,p o s i t i v e s}{t r u e\,\,p o s i t i v e s\,+\,f a l s e\,\,n e g a t i v e s}=0.95\,,}}\\ {{A}}&{{=}}&{{\frac{t r u e\,\,p o s i t i v e s\,+\,t r u e\,\,p e a t i v e s}{p o s i t i v e s\,\,+\,n e g a t i v e s}=0.97\,.}}\end{array}$$

These results are an improvement over those reported in (Lerman & Minton, 2000),
which produced P = 0.47, R = 0.95, A = 0.**91. The poor precision value reported in that**
work was due to 40 false positives obtained on the same data set. We attribute the improvements both to eliminating the specificity bias in the patterns learned by DataProG
and to changing the feature set to include only the starting patterns and additional numeric features. Note that this improvement does not result simply **from adding numeric features.**
To check this, we ran the verification experiments on a subset of data (the last 278 comparisons) using only the global numeric features and obtained P = 0.92 and R = 0.**55, whereas**
using both patterns and numeric features results in values of P = 0.71 and R = 1.**00 for** the same data set.

## 3.1.2 Discussion Of Results

Though we have succeeded in significantly reducing the number **of false positives, we have**
not managed to eliminate them altogether. There are a number **of reasons for their presence,**
some of which point to limitations in our approach.

We can split the types of errors into roughly three not entirely independent classes:
improper tokenization, incomplete data coverage, and data **format changes. The URL field**
(Table 6) accounted for a significant fraction of the false positives, in large part due to the design of our tokenizer, which splits text strings on punctuation marks. If the URL
contains embedded punctuation (as part of the alphanumeric **key associated with the user or**
session id), it will be split into a varying number of tokens, **so that it is hard to capture the**
regularity of the field. The solution is to rewrite the tokenizer to recognize URLs for which well defined specifications exist. We will address this problem **in our ongoing work. Our**
algorithm also failed sometimes (*e.g.*, arrowlist, showtimes**) when it learned very long and**
specific descriptions. It is worth pointing out, however, that it performed correctly in over two dozen comparisons for these sources. These types of errors are caused by incomplete data coverage: a larger, more varied training data set would **produce more general patterns,** which would perform better on the verification task. A striking example of the data coverage problem occurred for the stock quotes source: the day the training data was collected, there were many more down movements in the stock price than up, and the opposite was true on the day the test data was collected. As a result, the price change fields for those two days were dissimilar. Finally, because DataProG **learns the format of data, false positives will** inevitably result from changes in the data format and do not indicate a problem with the algorithm. This is the case for the factbook source, where the units of area changed from "km2" to "sq km".