
## 3.2 Wrapper Reinduction

If the wrapper stops extracting correctly, the next challenge is to rebuild it automatically (Cohen, 1999). The extraction rules for our wrappers (Muslea et al., 2001), as well as many others (cf. (Kushmerick et al., 1997; Hsu & Dung, 1998)), are generated by a machine learning algorithm, which takes as input several pages from **a source and labeled examples**
of data to extract from each page. It is assumed that the user labeled all examples correctly. If we label at least a few pages for which the wrapper fails by correctly identifying examples of data on them, we can use these examples as input to **the induction algorithm,** such as STALKER,
5to generate new extraction rules.6 Note that we do not need to identify the data on every page - depending on how regular the data **layout is,** Stalker can learn extraction rules using a small number of correctly labeled pages. Our solution is to bootstrap the wrapper induction process (which learns landmark-based rules) by learning content-based rules. We want to re-learn the landmark-based rules, because for the types of sites we use, these rules tend to be much more accurate and efficient than content-based rules.

We employ a method that takes a set of training examples, extracted from the source when the wrapper was known to be working correctly, and a set of pages from the same source, and uses a mixture of supervised and unsupervised learning techniques to identify examples of the data field on new pages. We assume that the format of data did not change. Patterns learned by DataProG **play a significant role in the reinduction task.** In addition to patterns, other features, such as the length of the training examples and structural information about pages are used. In fact, because page structure is used during a critical step of the algorithm, we discuss our approach to learning it in detail in the next paragraph.

## 3.2.1 Page Template Algorithm

Many Web sources use templates, or page skeletons, to automatically generate pages and fill them with results of a database query. This is evident in the example in Fig. 6. The template consists of the heading "RESULTS", followed by the **number of results that match**
the query, the phrase "Click links associated with businesses for more information," then the heading "ALL LISTINGS," followed by the anchors "map," "driving directions," "add to My Directory" and the bolded phrase "Appears in the Category." Obviously, data is not part of the template - rather, it appears in the *slots* **between template elements.**
Given two or more example pages from the same source, we can induce the template used to generate them (Table 7). The template finding algorithm looks for all sequences of tokens - both HTML tags and text - that appear exactly once on each page. The algorithm works in the following way: we pick the smallest page in the set as the template seed. Starting with the first token on this page, we grow a sequence by appending tokens