information on the page. Even text sources such as email messages have some structure in the heading that can be exploited to extract the date, sender, addressee, title, and body of the messages. Other sources, such as online catalogs, have a very regular structure that can be exploited to extract all the data automatically.

Wrappers rely on extraction rules to identify the data field to **be extracted. Semiautomatic creation of extraction rules, or wrapper induction, has been an active area of**
research in recent years (Knoblock, Lerman, Minton, & Muslea, 2001a; Kushmerick, Weld, & Doorenbos, 1997). The most advanced of these wrapper generation systems use machine learning techniques to learn the extraction rules by example. For instance, the wrapper induction tool developed at USC (Knoblock et al., 2001a; Muslea, Minton, & Knoblock, 1998) and commercialized by Fetch Technologies, allows the **user to mark up data to be** extracted on several example pages from an online source using a graphical user interface.

The system then generates "landmark"-based extraction rules for these data that rely on the page layout. The USC wrapper tool is able to efficiently create extraction rules from a small number of examples; moreover, it can extract data from pages that contain lists, nested structures, and other complicated formatting layouts.

In comparison to wrapper induction, wrapper maintenance has received less attention.

This is an important problem, because even slight changes in **the Web page layout can break**
a wrapper that uses landmark-based rules and prevent it from extracting data correctly. In this paper we discuss our approach to the wrapper maintenance problem, which consists of two parts: wrapper verification and reinduction. A *wrapper verification* **system monitors** the validity of data returned by the wrapper. If the site changes, the wrapper may extract nothing at all or some data that is not correct. The verification system will detect data inconsistency and notify the operator or automatically launch a wrapper repair process.

A *wrapper reinduction* **system repairs the extraction rules so that the wrapper works on** changed pages.

![0_image_0.png](0_image_0.png)

Figure 1 graphically illustrates the entire life cycle of a wrapper. As shown in the figure, the wrapper induction system takes a set of web pages labeled **with examples of the data to** be extracted. The output of the wrapper induction system is a **wrapper, consisting of a set**