
## 4.3 Information Extraction

Our system, as used in the reinduction task, is related in spirit to the many information extraction (IE) systems developed both by our group and others in that it uses a learned representation of data to extract information from specific texts. Like wrapper induction systems (see (Muslea et al., 2001; Kushmerick et al., 1997; Freitag & Kushmerick, 2000)), it is domain independent and works best with semi-structured **data,** *e.g.***, Web pages. It** does not handle free text as well as other systems, such as AutoSlog **(Riloff, 1993) and** Whisk **(Soderland, 1999), because free text has fewer non-trivial regularities the algorithm** can exploit. Unlike wrapper induction, it does not extract data based on the features that appear near it in text, but rather based on the content of data **itself. However, unlike** Whisk, which also learns content rules, our reinduction system represents each field independently of the other fields, which can be an advantage, for instance, when a web source changes the order in which data fields appear. Another difference is that our **system is designed to run**
automatically, without requiring any user interaction to label informative examples. In the main part because it is purely automatic, the reinduction system fails to achieve the accuracy of other IE systems which rely on labeled examples to train the system; however, we do not see it as a major limitation, since it was designed to *complement* **existing extraction** tools, rather than supersede them. In other words, we consider the reinduction task to be successful if it can accurately extract a sufficient number of examples to use in a wrapper induction system. The system can then use the resulting wrapper to accurately extract the rest of the data from the source.

There are many similarities between our approach and that used by the RoadRunner **system, developed concurrently with our system and reported recently in (Crescenzi,**
Mecca, & Merialdo, 2001b, 2001a). The goal of that system is to automatically extract data from Web sources by exploiting similarities in page structure across multiple pages.

RoadRunner **works by inducing the grammar of Web pages by comparing several pages**
containing long lists of data. The grammar is expressed at the HTML tag level, so it is similar to the extraction rules generated by Stalker**. The** RoadRunner **system has been**
shown to successfully extract data from several Web sites. The two significant differences between that work and ours are (i) they do not have a way of detecting changes to know when the wrapper has to be rebuilt and (ii) our reinduction algorithm works on detail pages only, while RoadRunner **works only on lists. We believe that our data-centric approach is**
more flexible and will allow us to extract data from more diverse information sources than the RoadRunner **approach that only looks at page structure.**

## 5. Conclusion

In this paper we have described the DataProG algorithm, which learns structural information about a data field from a set of examples of the field. We use **these patterns in**
two Web wrapper maintenance applications: (i) verification **— detecting when a wrapper** stops extracting data correctly from a Web source, and (ii) reinduction **— identifying new**
examples of the data field in order to rebuild the wrapper if it stops working. The verification algorithm performed with an accuracy of 97%, much better than results reported in our earlier work (Lerman & Minton, 2000). In the reinduction task, the patterns were used to identify a large number of data fields on Web pages, which were in turn used to