pattern <Number Upper> and end with a specific type <Boulevard> **or more generally**
<Upper>**. Note that the pattern language does not allow loops or recursion. We believe** that recursive expressions are not useful representations **of the types of data we are trying**
to learn, because they are harder to learn and lead to over-generalization.

## 2.2 Learning From Positive Examples

The problem of learning the data prototype from a set of examples that are labeled as belonging (or not) to a class may be stated in one of two related ways: as a classification or as a conservation task. In the classification task, both positive and negative instances of the class are used to learn a rule that will correctly classify new examples. Classification algorithms, like FOIL (Quinlan, 1990), use negative examples to guide the specialization of the rule. They construct discriminating descriptions - those that are satisfied by the positive examples and not the negative examples. The conservation task, on the other hand, attempts to find a characteristic description (Dietterich & Michalski, 1981) or conserved patterns (Brazma, Jonassen, Eidhammer, & Gilbert, 1995), in a set of positive examples of a class. Unlike the discriminating description, the characteristic description will often include redundant features. For example, when learning a description of street addresses, with city names serving as negative examples, a classification algorithm will learn that <Number> is a good description, because all the street addresses start with it and none of the city names do. The capitalized word that follows the number in addresses is a redundant feature, because it does not add to the discriminating power of the learned description. However, if an application using this description encounters a zipcode **in the future, it will incorrectly**
classify it as a street address. This problem could have been **avoided if** <Number Upper>
was learned as a description of street addresses. Therefore, when negative examples are not available to the learning algorithm, the description has to capture all the regularity of data, including the redundant features, in order to correctly identify new instances of the class and differentiate them from other classes. Ideally, **the characteristic description**
learned from positive examples alone is the same as the discriminating description learned by the classification algorithm from positive and negative examples, where negative examples are drawn from infinitely many classes. While most of the widely used machine learning algorithms (*e.g.***, decision trees (Quinlan, 1993), inductive logic programming (Muggleton,** 1991)) solve the classification task, there are fewer algorithms that learn characteristic descriptions.

In our applications, an appropriate source of negative examples is problematic; therefore, we chose to frame the learning problem as a conservation task. We introduce an algorithm that learns data prototypes from positive examples of the data field alone. The algorithm finds statistically significant sequences of tokens. A sequence of token types is significant if it occurs more frequently than would be expected if the tokens were generated randomly and independently of one another. In other words, each such sequence constitutes a pattern that describes many of the positive examples of data and is highly unlikely to have been generated by chance.

The algorithm estimates the baseline probability of a token **type's occurrence from the**
proportion of all types in the examples of the data field that are of that type. Suppose we are learning a description of the set of street addresses in Fig. 2, and have already found