a significant token sequence - *e.g.***, the pattern consisting of the single token** <Number>
- and want to determine whether the more specific pattern, <Number Upper>**, is also** a significant pattern. Knowing the probability of occurrence **of the type** Upper**, we can**
compute how many times Upper **can be expected to follow** Number **completely by chance.** If we observe a considerably greater number of these sequences, we conclude that the longer pattern is also significant.

We use hypothesis testing (Papoulis, 1990) to decide whether a pattern is significant.

The null hypothesis is that observed instances of this pattern were generated by chance, via the random, independent generation of the individual token types. Hypothesis testing decides, at a given confidence level, whether the data supports rejecting the null hypothesis. Suppose n identical sequences have been generated by a random source. **The probability** that a token type T (whose overall probability of occurrence is p**) will be the next type in**
k of these sequences has a binomial distribution. For a large n**, the binomial distribution**
approaches a normal distribution P(x, µ, σ) with µ = np and σ 2 = np(1−p**). The cumulative**
probability is the probability of observing at least n1 **events:**

$$P(k\geq n_{1})=\int_{n_{1}}^{\infty}P(x,\mu,\sigma)dx\tag{1}$$  We use polynomial approximation formulas (Abramowitz & Stegun, 1964) to compute the 

value of the integral.

The significance level of the test, α**, is the probability that the null hypothesis is rejected**
even though it is true, and it is given by the cumulative probability above. Suppose we set α = 0.05. This means that we expect to observe at least n1 **events 5% of the time under the**
null hypothesis. If the number of observed events is greater, we reject the null hypothesis (at the given significance level), *i.e.***, decide that the observation is significant. Note that** the hypothesis we test is derived from observation (data). This constraint reduces the number of degrees of freedom of the test; therefore, we must subtract one from the number of observed events. This also prevents the anomalous case when a single occurrence of a rare event is judged to be significant.

## 2.3 Dataprog **Algorithm**

We now describe DataProG**, the algorithm that finds statistically significant patterns in a**
set of token sequences. During the preprocessing step the text is tokenized, and the tokens are assigned one or more syntactic types (see Figure 3). The patterns are encoded in a type of prefix tree, where each node corresponds to a token type. DataProG **relies on** significance judgements to grow the tree and prune the nodes. Every path through the resulting tree starting at the root node corresponds to a significant pattern found by the algorithm. In this section, we focus the discussion on the version of the algorithm that learns starting patterns. The algorithm is easily adapted to learn ending patterns.

We present the pseudocode of the DataProG **algorithm in Table 1.** DataProG **grows**
the pattern tree incrementally by (1) finding all significant specializations (*i.e.***, longer patterns) of a pattern and (2) pruning the less significant of the generalizations (or specializations) among patterns of the same length. As the last step,** DataProG **extracts all**
significant patterns from the pattern tree, including those generalizations (*i.e.***, shorter patterns) found to be significant given the more specific (***i.e.***, longer) patterns.**