Finally the wrapper methods rely on the information about feature relevance obtained from some classification method [16] and therefore may use deeper insight in data than filters. Wrappers are usually created around particular classifier, but may in principle use any classifier that also provides some measure of feature importance. The wrapper methods are best suited for *all relevant* feature selection; the computational effort they require is usually significant, but inevitable to get comprehensive view in attribute relevance.

## 1.3 All Relevant Feature Selection

There are two issues that are central for the *all relevant* problem but non-existent for the *minimal optimal* one. The first issue is detection of weakly relevant attributes that can be completely obscured by other attributes, the second is discerning between weakly but truly relevant variables from those that are only seemingly relevant due to random fluctuations.

The concepts of strong and weak relevance, and consequently also a problem of *all relevant* feature selection, are defined in a context of a perfect classifier that is able to use all available information. Yet, in the real world applications one is restricted to use imperfect classification algorithms that are not capable to use all information present in the information system, what may influence the outcome of the feature selection algorithm. In particular, an algorithm may not be able to find and use some of the relevant features.

In many cases this won't disturb the solution of a *minimal optimal* problem, provided that the final predictions of the classifier are sufficiently accurate; yet it will significantly decrease the sensitivity of *all relevant* feature selection. Hence, the classification algorithm used in *all relevant* feature selection should be able to detect weak and redundant attributes.

The features of the random forest algorithm [2] make it a promising candidate for this task. It is an ensemble of numerous weak classifiers (decision trees), each of these classifiers is constructed using different subset of variables and different subset of objects. During the construction process, each variable has numerous chances to be included in the classifier, so even weakly relevant attributes that are marginally related with the decision attribute will be used for construction of individual classifiers. Moreover, the importance of the attribute is measured using only the trees that use given attribute, therefore the signal for attributes contributing to a small number of trees is still visible. In addition the random forest has some additional advantages for use as wrapper's engine; it has very few tunable parameters, is relatively efficient computationally and the importance evaluation does not incur significant computational overheads.

The second issue, namely discerning between the truly and randomly relevant attributes arises because the analyses are performed for a finite size samples.

This gives a chance for random correlations to emerge and significantly influence the results. The probability of such event increases with decreasing number of objects; the effect is also boosted by overall large number of attributes, which in addition increases chances for random interactions between features. This issue