
## 3.3 Gene Expression Data

The third experiment was designed to show an example of a real-world *all relevant* feature selection use, namely the analysis of the results of microarray experiment. Such data sets usually comprise relatively few objects (often less than one hundred), and are described with several thousands of attributes. Moreover, finding genes that are relevant for the studied phenomena is usually the main goal of the experimental study.

A well known problem of detecting the differences between two subtypes of leukemia from a seminal work of Golub [8] was examined. This data was deeply investigated before, thus gives a chance to compare the results of Boruta with three previously published results obtained using various other methods.

Several variants of this set were analysed in the literature and are available in public repositories; in this work, the data set golub available from *hopach* Bioconductor package [24] was used. It consists of the data on 38 patients described with expression levels of 3051 genes. The raw data was preprocessed there as described in [5].

The gene relevance was assessed with Boruta algorithm based on the random forest consisting of increasing number of trees. The number of trees in the forest varied between 500 and 100 000. Each run was repeated 15 times. To assess the possibility of false positive hits the analysis was repeated using a semi-synthetic version of Golub set. In this set the original attributes were augmented with 1000 additional synthetic attributes constructed by randomly selecting 1000 original attributes and permuting their values between objects.

## 4 Results 4.1 Synthetic Data

The algorithms were compared for thirty parameter sets forming regular grid in the space of attribute number versus object number, see Figure 1. The problem difficulty grows with increasing number of attributes and decreasing number of objects, reaching maximum in the top right corner of the plot.

All algorithms were using the same source of attribute importance. The reference algorithm Top returns best possible information retrievable from the single random forest run. It is used both to estimate quality of the random forest feature ranking and as a reference for the heuristic algorithms. For the remaining three algorithms the test was focused on the second issue of *all relevant* feature selection, the discerning between relevant and irrelevant features. Thus, it effectively tested if the method is able to discover the number of relevant features from the importance spectrum.

Three parameters were used to compare the results of four algorithms, namely the number of true positives (sensitivity), the number of false positives (selectivity) and F-score which is a harmonic mean of two previous numbers and a good measure of the overall quality of the algorithm.