Procedure forward-check (Π)

1. Topologically sort all variables V **based on the the causal graph.**
2. For each variable v ∈ V, call determine-max-sequence(Π, v**), respecting the above**
ordering.

3. If one of the calls to determine-max-sequence **return failure, then return failure.**
Otherwise return success.

Procedure determine-max-sequence (Π, v)
1. If pred(v) = ∅ **then**
(a) If v 0 6= v
∗ and A+
v 6∈ Λv**, return failure.**
(b) Otherwise, determine σ(v**) according to the rules in Table 2, and return success.**
2. Otherwise, if pred(v) = {w1, . . . , wk} **then**
(a) Construct G(v**) (based on** v 0, v∗**, and Λ**⊲⊳
v).

(b) Construct G′(v) (from G(v), based on σ(w1), . . . σ(wk)).

(c) Construct G′e(v) (from G′(v), based on σ(w1), . . . σ(wk)).

(d) Determine the longest path in G′e(v**) to a node corresponding to a** v
∗**-ended value**
change, and derive σ(v**) and the corresponding sequence of operators from it.**
(e) If v 0 6= v
∗ and FMaxReq(v**) = 0, return failure. Otherwise, return success.**
Figure 5: forward-check **algorithm**
instances Γv = {A(ν iv
)}
FMaxReq(v)
i=2 **, where** A(ν iv
) has ν iv as its effect, and

$$\nu_{v}^{i}=\left\{\begin{array}{l l}{{{\bf b}_{v}^{\frac{i+1}{2}},}}&{{\quad i=2k+1}}\\ {{{\bf w}_{v}^{\frac{i}{2}},}}&{{\quad i=2k}}\end{array}\right.\quad k\in\mathbb{N}$$

Procedure forward-check **in Figure 5 summarizes the presented approach. Note that**
finding a set of longest paths from a node to all other nodes in a **directed acyclic graph**
can be done in time linear in the size of the graph (Wiest & Levy, 1969). Therefore, the time complexity of a call to the determine-max-sequence **procedure with a variable** v is bounded by the size of the constructed graph G′e(v**) and thus is** O(n 2k+2 ·|Λ
⊲⊳
v| 2). forwardcheck calls determine-max-sequence n **times. Therefore, if the maximal node indegree**
is bounded by a constant κ, then the overall complexity of the algorithm is O(|V|2κ+3·2 2κ+2),
i.e., polynomial in the size of the problem description.

Theorem 1 **A given problem instance with a polytree causal graph is solvable if and only**
if, for each v ∈ V, forward-check **succeeds in constructing the maximal sequence** σ(v).

forward-check fails if and only if at least one of the calls to the determine-maxsequence procedure fails. In turn, a call to determine-max-sequence **on a variable** v