
## 4. Directed-Path Singly Connected And General Dags

In this section we analyze planning complexity in face of more complicated causal graphs. First, we show that when the causal graph is directed-path singly connected even plan existence is np**-complete. Second, we show that for general causal graphs the situation is**
even worse. Finally, we characterize an important parameter of the causal graph affecting planning complexity, which allows us to extend the class of problems which are in np.

Theorem 2 Plan existence for strips planning problems with unary operators and directedpath singly connected causal graph is np**-complete.**
Proof: **For the proof see Appendix B, p. 346.** 
Note that node indegree in the causal graph of the problem created in the proof of Theorem 2 is bounded by 6. The hardness for directed-path singly connected causal graphs with maximal indegree lower than 6 is thus open.

The directed-path singly connected structure of the causal **graph turns out to be crucial**
for guaranteeing reasonable solution times. As we now show, **there are solvable propositional planning problems with an arbitrary acyclic (DAG) causal graph that have minimal**
solutions of exponential size. Analysis of this class of problems points to the reason for such provable intractability. This allows us to characterize an **important parameter of the causal**
graph affecting planning complexity and to extend the class of problems which are in np. However, all these restricted problems are still np**-complete.** Theorem 3 Plan generation for general strips **planning problems with unary operators** and acyclic causal graph is provably intractable, i.e. it is **harder than** np.

This theorem follows from Theorem 5.4 in (Jonsson & B¨ackstr¨om, 1998b), that shows that plan generation for the 3S problem class is provably intractable. The point is that the upper bound for MinPlanSize**, presented in Eq. 5, can be exponential in the size of the input**
in this case. First, we show by example that this upper bound can be achieved, then we present some analysis of the reasons for this intractability.

The following example shows that an exponential upper bound **can be achieved. It was**
used in the proof of Theorem 5.4 in (Jonsson & B¨ackstr¨om, 1998b), and was originally presented in a different context by B¨ackstr¨om and Nebel (1995). Consider a propositional planning problem with |V| = n, where, for 1 ≤ i ≤ n, D(vi) = {0, 1} and pred(vi) =
{v1, . . . vi−1}. The operator set Λ consist of 2n operators {A1, A′1
, . . . An, A′n
} **where**

$$\operatorname{pre}(A_{i})[j]=\operatorname{post}(A_{i}^{\prime})[j]={\left\{\begin{array}{l l}{0}&{{\mathrm{if~}}j=i}\\ {\mathfrak{u}}&{{\mathrm{otherwise}}}\end{array}\right.}$$  $$\operatorname{pre}(A_{i}^{\prime})[j]=\operatorname{post}(A_{i})[j]={\left\{\begin{array}{l l}{1}&{{\mathrm{if~}}j=i}\\ {\mathfrak{u}}&{{\mathrm{otherwise}}}\end{array}\right.}$$  $$\operatorname{prov}(A_{i})[j]=\operatorname{prov}(A_{i}^{\prime})[j]={\left\{\begin{array}{l l}{0}&{{\mathrm{if~}}j<i-1}\\ {1}&{{\mathrm{if~}}j=i-1}\\ {\mathfrak{u}}&{{\mathrm{otherwise}}}\end{array}\right.}$$
