example, Bylander (1994) showed that strips **planning in domains where each operator is**
restricted to have positive preconditions and one postcondition only is tractable. B¨ackstr¨om and Klein (1991b) considered other, more global types of syntactical restrictions, but using a more refined model in which two types of preconditions are considered: prevail **conditions,** which are variable values that are required prior to the execution of the operator and are not affected by the operator, and preconditions, which are **affected by the operator. For** example, they have shown that when operators have a single effect, no two operators have the same effect, and each variable can be affected only in one context (of prevail conditions) then the planning problem can be solved in polynomial time. However, these restrictions are very strict, and it is difficult to find reasonable domains satisfying them.

In this paper we concentrate on more global properties of unary operator domains; properties that capture some of the interactions between different planning operators. The tool we use to study these properties is the domains' causal graph**. A causal graph is a**
directed graph whose nodes stand for the domain propositions. An edge (p, q**) appears in**
the causal graph if and only if some operator that changes the value of q **has a prevail**
condition involving p**. Such a problem structure was introduced by Knoblock (1994)** in the context of automatically generating abstractions for planning. Subsequently, Jonsson and B¨ackstr¨om (1998b) introduced the 3S class of planning **problems with unary operators,** which was characterized by the acyclicity of the causal graph, and some restrictions on the operator set. It was shown that determining plan existence for this class of problems is polynomial, while plan generation is provably intractable.

Complexity results for unary operators would be of theoretical interest alone if one could not supply interesting problems in which unary operators are used. One interesting application in which this problem arises is the determination of dominance relationship between different outcomes in a CP-net (Boutilier, Brafman, **Hoos, & Poole, 1999). This**
problem is reducible to strips **planning with unary operators.**
Another example, of greater interest to the planning community, is a planning-based reactive control system that commands the NASA Deep Space One autonomous spacecraft (Pell, Bernard, Chien, Gat, Muscettola, Nayak, Wagner, & Williams, 1997; Williams
& Nayak, 1996, 1997). This system was hailed by Weld (1999) in **his recent survey of AI**
planning as one of the most exciting recent developments in the area of planning. Naturally, the complete system (Pell et al., 1997) is very complex, however, its configuration planning and execution subsystem are of particular interest to us. In the context of controlling Deep-Space One, Williams and Nayak (1996, 1997) present a reactive planner, Burton, that generates a single control action for the main engine subsystem of the spacecraft, and compensates for anomalies at every step. Given a high-level **goal (for example, thrust in** one of the engines), Burton continually tries to transition **the system toward a state that** satisfies the desired goal. What is particularly relevant for us is that Burton's task can be described as a strips planning problem in which each operator affects only a single variable (hardware component) - Williams and Nayak (1997) argue **that in physical hardware**
it is usually the case that each state variable is commanded separately. However, Burton is based on two additional important restrictions: First, the **planner is explicitly supplied with** a serialization order for any satisfiable set of goal. Second, all operators must be reversible.

One of the reasons cited for designing Burton as a reactive planner that generates a single action at a time was the potential intractability of generating whole plans. Indeed,